package com.xforceplus.jcbaolong.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-04-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderBillHead implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("billNo")
  private String billNo;

  @TableField("supplierName")
  private String supplierName;

  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  @TableField("supplierTaxNo")
  private String supplierTaxNo;

  @TableField("contractNo")
  private String contractNo;

  @TableField("pdNo")
  private String pdNo;

  @TableField("billableAmount")
  private BigDecimal billableAmount;

  @TableField("invoiceAmount")
  private BigDecimal invoiceAmount;

  @TableField("isCoordination")
  private Boolean isCoordination;

  @TableField("isParent")
  private Boolean isParent;

  @TableField("parentBillNo")
  private String parentBillNo;

  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  @TableField("purchaserName")
  private String purchaserName;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("supplierCode")
  private String supplierCode;

  @TableField("purchaserCode")
  private String purchaserCode;

  @TableField("operStatus")
  private String operStatus;

  @TableField("orderDesc")
  private String orderDesc;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("billNo", billNo);
      map.put("supplierName", supplierName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("supplierTaxNo", supplierTaxNo);
      map.put("contractNo", contractNo);
      map.put("pdNo", pdNo);
      map.put("billableAmount", billableAmount);
      map.put("invoiceAmount", invoiceAmount);
      map.put("isCoordination", isCoordination);
      map.put("isParent", isParent);
      map.put("parentBillNo", parentBillNo);
      map.put("amountWithTax", amountWithTax);
      map.put("purchaserName", purchaserName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("supplierCode", supplierCode);
      map.put("purchaserCode", purchaserCode);
      map.put("operStatus", operStatus);
      map.put("orderDesc", orderDesc);
      return map;
  }

  public static OrderBillHead fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    OrderBillHead entity = new OrderBillHead();
    if(map.containsKey("billNo")) {
      Object obj = map.get("billNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierTaxNo")) {
      Object obj = map.get("supplierTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractNo")) {
      Object obj = map.get("contractNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdNo")) {
      Object obj = map.get("pdNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPdNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billableAmount")) {
      Object obj = map.get("billableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBillableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isCoordination")) {
      Object obj = map.get("isCoordination");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsCoordination((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsCoordination(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("isParent")) {
      Object obj = map.get("isParent");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsParent((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsParent(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("parentBillNo")) {
      Object obj = map.get("parentBillNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setParentBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserCode")) {
      Object obj = map.get("purchaserCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operStatus")) {
      Object obj = map.get("operStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOperStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderDesc")) {
      Object obj = map.get("orderDesc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderDesc((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
