package com.xforceplus.jcbaolongentry.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-07-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BasicInfoSuppliers implements Serializable {

  private static final long serialVersionUID=1L;

  private String supplierTaxNo;

  private String supplierName;

  private String registerAddress;

  private Long registerCapital;

  private String registerYear;

  private String legalPerson;

  private String officialWebsite;

  private String supplierType;

  private String companyType;

  private String businessLicense;

  private String account;

  private String password;

  private String telephone;

  private String email;

  private String bankNumber;

  private String depositBank;

  private String bankAccountNumber;

  private String bankContact;

  private String contactInformation;

  private String contacts;

  private String references;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("supplier_tax_no", supplierTaxNo);
      map.put("supplier_name", supplierName);
      map.put("register_address", registerAddress);
      map.put("register_capital", registerCapital);
      map.put("register_year", registerYear);
      map.put("legal_person", legalPerson);
      map.put("official_website", officialWebsite);
      map.put("supplier_type", supplierType);
      map.put("company_type", companyType);
      map.put("business_license", businessLicense);
      map.put("account", account);
      map.put("password", password);
      map.put("telephone", telephone);
      map.put("email", email);
      map.put("bank_number", bankNumber);
      map.put("deposit_bank", depositBank);
      map.put("bank_account_number", bankAccountNumber);
      map.put("bank_contact", bankContact);
      map.put("contact_information", contactInformation);
      map.put("contacts", contacts);
      map.put("references", references);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static BasicInfoSuppliers fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BasicInfoSuppliers entity = new BasicInfoSuppliers();
    if(map.containsKey("supplier_tax_no")) {
      Object obj = map.get("supplier_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplier_name")) {
      Object obj = map.get("supplier_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("register_address")) {
      Object obj = map.get("register_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegisterAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("register_capital")) {
      Object obj = map.get("register_capital");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRegisterCapital((Long)obj);
        } else if(obj instanceof String) {
          entity.setRegisterCapital(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRegisterCapital(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("register_year")) {
      Object obj = map.get("register_year");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegisterYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("legal_person")) {
      Object obj = map.get("legal_person");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLegalPerson((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("official_website")) {
      Object obj = map.get("official_website");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOfficialWebsite((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplier_type")) {
      Object obj = map.get("supplier_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSupplierType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_type")) {
      Object obj = map.get("company_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_license")) {
      Object obj = map.get("business_license");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessLicense((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account")) {
      Object obj = map.get("account");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("password")) {
      Object obj = map.get("password");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPassword((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("telephone")) {
      Object obj = map.get("telephone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("email")) {
      Object obj = map.get("email");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bank_number")) {
      Object obj = map.get("bank_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deposit_bank")) {
      Object obj = map.get("deposit_bank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepositBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bank_account_number")) {
      Object obj = map.get("bank_account_number");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankAccountNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bank_contact")) {
      Object obj = map.get("bank_contact");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankContact((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contact_information")) {
      Object obj = map.get("contact_information");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContactInformation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contacts")) {
      Object obj = map.get("contacts");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContacts((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("references")) {
      Object obj = map.get("references");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReferences((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
