package com.xforceplus.jcbaolongentry.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcbaolongentry.entity.BasicInfoSuppliers;
import com.xforceplus.jcbaolongentry.service.IBasicInfoSuppliersService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-05
 */
@RestController
public class BasicInfoSuppliersController {

  @Autowired
  private IBasicInfoSuppliersService basicInfoSuppliersServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param basicInfoSuppliers ${table.comment}
   * @return
   */
  @GetMapping("/basicinfosupplierss" )
  public XfR getBasicInfoSupplierss(XfPage page, BasicInfoSuppliers basicInfoSuppliers) {
    return XfR.ok(basicInfoSuppliersServiceImpl.page(page, Wrappers.query(basicInfoSuppliers)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/basicinfosupplierss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(basicInfoSuppliersServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param basicInfoSuppliers ${table.comment}
   * @return XfR
   */
  @PostMapping("/basicinfosupplierss")
  public XfR save(@RequestBody BasicInfoSuppliers basicInfoSuppliers) {
     return XfR.ok(basicInfoSuppliersServiceImpl.save(basicInfoSuppliers));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param basicInfoSuppliers ${table.comment}
   * @return XfR
   */
  @PutMapping("/basicinfosupplierss/{id}")
  public XfR putUpdate(@RequestBody BasicInfoSuppliers basicInfoSuppliers,@PathVariable Long id) {
      basicInfoSuppliers.setId(id);
      return XfR.ok(basicInfoSuppliersServiceImpl.updateById(basicInfoSuppliers));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param basicInfoSuppliers ${table.comment}
   * @return XfR
   */
  @PatchMapping("/basicinfosupplierss/{id}")
  public XfR patchUpdate(@RequestBody BasicInfoSuppliers basicInfoSuppliers,@PathVariable Long id) {
      BasicInfoSuppliers upbasicInfoSuppliers = basicInfoSuppliersServiceImpl.getById(id);
      if(upbasicInfoSuppliers != null){
        upbasicInfoSuppliers = ObjectCopyUtils.copyProperties(basicInfoSuppliers,upbasicInfoSuppliers,true);
      }
      return XfR.ok(basicInfoSuppliersServiceImpl.updateById(upbasicInfoSuppliers));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/basicinfosupplierss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(basicInfoSuppliersServiceImpl.removeById(id));
  }

  @PostMapping("/basicinfosupplierss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "basic_info_suppliers");
     params.put("request", condition);

     return XfR.ok(basicInfoSuppliersServiceImpl.querys(params));
  }

}
