package com.xforceplus.jcbaolongentry.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcbaolongentry.entity.ProjectInfo;
import com.xforceplus.jcbaolongentry.service.IProjectInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-05
 */
@RestController
public class ProjectInfoController {

  @Autowired
  private IProjectInfoService projectInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param projectInfo ${table.comment}
   * @return
   */
  @GetMapping("/projectinfos" )
  public XfR getProjectInfos(XfPage page, ProjectInfo projectInfo) {
    return XfR.ok(projectInfoServiceImpl.page(page, Wrappers.query(projectInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/projectinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(projectInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param projectInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/projectinfos")
  public XfR save(@RequestBody ProjectInfo projectInfo) {
     return XfR.ok(projectInfoServiceImpl.save(projectInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param projectInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/projectinfos/{id}")
  public XfR putUpdate(@RequestBody ProjectInfo projectInfo,@PathVariable Long id) {
      projectInfo.setId(id);
      return XfR.ok(projectInfoServiceImpl.updateById(projectInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param projectInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/projectinfos/{id}")
  public XfR patchUpdate(@RequestBody ProjectInfo projectInfo,@PathVariable Long id) {
      ProjectInfo upprojectInfo = projectInfoServiceImpl.getById(id);
      if(upprojectInfo != null){
        upprojectInfo = ObjectCopyUtils.copyProperties(projectInfo,upprojectInfo,true);
      }
      return XfR.ok(projectInfoServiceImpl.updateById(upprojectInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/projectinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(projectInfoServiceImpl.removeById(id));
  }

  @PostMapping("/projectinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "project_info");
     params.put("request", condition);

     return XfR.ok(projectInfoServiceImpl.querys(params));
  }

}
