package com.xforceplus.jcbaolong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcbaolong.entity.InterfaceRecord;
import com.xforceplus.jcbaolong.service.IInterfaceRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-23
 */
@RestController
public class InterfaceRecordController {

  @Autowired
  private IInterfaceRecordService interfaceRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param interfaceRecord ${table.comment}
   * @return
   */
  @GetMapping("/interfacerecords" )
  public XfR getInterfaceRecords(XfPage page, InterfaceRecord interfaceRecord) {
    return XfR.ok(interfaceRecordServiceImpl.page(page, Wrappers.query(interfaceRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/interfacerecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(interfaceRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param interfaceRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/interfacerecords")
  public XfR save(@RequestBody InterfaceRecord interfaceRecord) {
     return XfR.ok(interfaceRecordServiceImpl.save(interfaceRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param interfaceRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/interfacerecords/{id}")
  public XfR putUpdate(@RequestBody InterfaceRecord interfaceRecord,@PathVariable Long id) {
      interfaceRecord.setId(id);
      return XfR.ok(interfaceRecordServiceImpl.updateById(interfaceRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param interfaceRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/interfacerecords/{id}")
  public XfR patchUpdate(@RequestBody InterfaceRecord interfaceRecord,@PathVariable Long id) {
      InterfaceRecord upinterfaceRecord = interfaceRecordServiceImpl.getById(id);
      if(upinterfaceRecord != null){
        upinterfaceRecord = ObjectCopyUtils.copyProperties(interfaceRecord,upinterfaceRecord,true);
      }
      return XfR.ok(interfaceRecordServiceImpl.updateById(upinterfaceRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/interfacerecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(interfaceRecordServiceImpl.removeById(id));
  }

  @PostMapping("/interfacerecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "interface_record");
     params.put("request", condition);

     return XfR.ok(interfaceRecordServiceImpl.querys(params));
  }

}
