package com.xforceplus.jcbaolong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcbaolong.entity.OrderBillDetails;
import com.xforceplus.jcbaolong.service.IOrderBillDetailsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-23
 */
@RestController
public class OrderBillDetailsController {

  @Autowired
  private IOrderBillDetailsService orderBillDetailsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderBillDetails ${table.comment}
   * @return
   */
  @GetMapping("/orderbilldetailss" )
  public XfR getOrderBillDetailss(XfPage page, OrderBillDetails orderBillDetails) {
    return XfR.ok(orderBillDetailsServiceImpl.page(page, Wrappers.query(orderBillDetails)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderbilldetailss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderBillDetailsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderBillDetails ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderbilldetailss")
  public XfR save(@RequestBody OrderBillDetails orderBillDetails) {
     return XfR.ok(orderBillDetailsServiceImpl.save(orderBillDetails));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderBillDetails ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderbilldetailss/{id}")
  public XfR putUpdate(@RequestBody OrderBillDetails orderBillDetails,@PathVariable Long id) {
      orderBillDetails.setId(id);
      return XfR.ok(orderBillDetailsServiceImpl.updateById(orderBillDetails));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderBillDetails ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderbilldetailss/{id}")
  public XfR patchUpdate(@RequestBody OrderBillDetails orderBillDetails,@PathVariable Long id) {
      OrderBillDetails uporderBillDetails = orderBillDetailsServiceImpl.getById(id);
      if(uporderBillDetails != null){
        uporderBillDetails = ObjectCopyUtils.copyProperties(orderBillDetails,uporderBillDetails,true);
      }
      return XfR.ok(orderBillDetailsServiceImpl.updateById(uporderBillDetails));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderbilldetailss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderBillDetailsServiceImpl.removeById(id));
  }

  @PostMapping("/orderbilldetailss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_bill_details");
     params.put("request", condition);

     return XfR.ok(orderBillDetailsServiceImpl.querys(params));
  }

}
