package com.xforceplus.jcbaolong.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcbaolong.entity.OrderBillDetailsRecord;
import com.xforceplus.jcbaolong.service.IOrderBillDetailsRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-04-23
 */
@RestController
public class OrderBillDetailsRecordController {

  @Autowired
  private IOrderBillDetailsRecordService orderBillDetailsRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderBillDetailsRecord ${table.comment}
   * @return
   */
  @GetMapping("/orderbilldetailsrecords" )
  public XfR getOrderBillDetailsRecords(XfPage page, OrderBillDetailsRecord orderBillDetailsRecord) {
    return XfR.ok(orderBillDetailsRecordServiceImpl.page(page, Wrappers.query(orderBillDetailsRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderbilldetailsrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderBillDetailsRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderBillDetailsRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderbilldetailsrecords")
  public XfR save(@RequestBody OrderBillDetailsRecord orderBillDetailsRecord) {
     return XfR.ok(orderBillDetailsRecordServiceImpl.save(orderBillDetailsRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderBillDetailsRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderbilldetailsrecords/{id}")
  public XfR putUpdate(@RequestBody OrderBillDetailsRecord orderBillDetailsRecord,@PathVariable Long id) {
      orderBillDetailsRecord.setId(id);
      return XfR.ok(orderBillDetailsRecordServiceImpl.updateById(orderBillDetailsRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderBillDetailsRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderbilldetailsrecords/{id}")
  public XfR patchUpdate(@RequestBody OrderBillDetailsRecord orderBillDetailsRecord,@PathVariable Long id) {
      OrderBillDetailsRecord uporderBillDetailsRecord = orderBillDetailsRecordServiceImpl.getById(id);
      if(uporderBillDetailsRecord != null){
        uporderBillDetailsRecord = ObjectCopyUtils.copyProperties(orderBillDetailsRecord,uporderBillDetailsRecord,true);
      }
      return XfR.ok(orderBillDetailsRecordServiceImpl.updateById(uporderBillDetailsRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderbilldetailsrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderBillDetailsRecordServiceImpl.removeById(id));
  }

  @PostMapping("/orderbilldetailsrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_bill_details_record");
     params.put("request", condition);

     return XfR.ok(orderBillDetailsRecordServiceImpl.querys(params));
  }

}
