package com.xforceplus.jcbusinesslabel.controller;


/**
 * 配置明细表feign客户端
 *
 * @author ultraman
 * @date 2022-11-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcbusinesslabel.entity.ConfigDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-business-label")
public interface ConfigDetailFeignApi {

  /**
   * 通过id查询配置明细表
   * @param  id
   * @return R
   */
  @GetMapping("/configDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增配置明细表
   * @param configDetail 配置明细表
   * @return R
   */
  @PostMapping("/configDetail/add")
  public R save(@RequestBody ConfigDetail configDetail);

  /**
   * 修改配置明细表
   * @param configDetail 配置明细表
   * @return R
   */
  @PostMapping("/configDetail/update")
  public R updateById(@RequestBody ConfigDetail configDetail);

  /**
   * 通过id删除配置明细表
   * @param  id
   * @return R
   */
  @DeleteMapping("/configDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}