package com.xforceplus.jcbusinesslabel.controller;


/**
 * 发票明细表feign客户端
 *
 * @author ultraman
 * @date 2022-11-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jcbusinesslabel.entity.InvoiceDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-business-label")
public interface InvoiceDetailFeignApi {

  /**
   * 通过id查询发票明细表
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票明细表
   * @param invoiceDetail 发票明细表
   * @return R
   */
  @PostMapping("/invoiceDetail/add")
  public R save(@RequestBody InvoiceDetail invoiceDetail);

  /**
   * 修改发票明细表
   * @param invoiceDetail 发票明细表
   * @return R
   */
  @PostMapping("/invoiceDetail/update")
  public R updateById(@RequestBody InvoiceDetail invoiceDetail);

  /**
   * 通过id删除发票明细表
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}