package com.xforceplus.jcbusinesslabel.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 类型
 * </p>
 *
 * @author ultraman
 * @since 2022-11-14
 */
public enum Type {

    STANDARD_PURCHASE_INVOICE_SYNC_EVENT("standard-purchase-invoice-sync-event", "标准进项发票协同");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Type(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Type fromCode(String code){
        switch(code) {
            case "standard-purchase-invoice-sync-event":
                return STANDARD_PURCHASE_INVOICE_SYNC_EVENT;
            default:
                return null;
        }
    }
}
