package com.xforceplus.jcbyd.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-06-01
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcbyd.entity.InvoiceTemplate;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-byd")
public interface InvoiceTemplateFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceTemplate/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param invoiceTemplate ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceTemplate/add")
  public R save(@RequestBody InvoiceTemplate invoiceTemplate);

  /**
   * 修改${table.comment}
   * @param invoiceTemplate ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceTemplate/update")
  public R updateById(@RequestBody InvoiceTemplate invoiceTemplate);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceTemplate/del/{id}" )
  public R removeById(@PathVariable Long id);

}