package com.xforceplus.jcbyd.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcbyd.entity.MaterialMasterData;
import com.xforceplus.jcbyd.service.IMaterialMasterDataService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-01
 */
@RestController
public class MaterialMasterDataController {

  @Autowired
  private IMaterialMasterDataService materialMasterDataServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param materialMasterData ${table.comment}
   * @return
   */
  @GetMapping("/materialmasterdatas" )
  public XfR getMaterialMasterDatas(XfPage page, MaterialMasterData materialMasterData) {
    return XfR.ok(materialMasterDataServiceImpl.page(page, Wrappers.query(materialMasterData)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/materialmasterdatas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(materialMasterDataServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param materialMasterData ${table.comment}
   * @return XfR
   */
  @PostMapping("/materialmasterdatas")
  public XfR save(@RequestBody MaterialMasterData materialMasterData) {
     return XfR.ok(materialMasterDataServiceImpl.save(materialMasterData));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param materialMasterData ${table.comment}
   * @return XfR
   */
  @PutMapping("/materialmasterdatas/{id}")
  public XfR putUpdate(@RequestBody MaterialMasterData materialMasterData,@PathVariable Long id) {
      materialMasterData.setId(id);
      return XfR.ok(materialMasterDataServiceImpl.updateById(materialMasterData));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param materialMasterData ${table.comment}
   * @return XfR
   */
  @PatchMapping("/materialmasterdatas/{id}")
  public XfR patchUpdate(@RequestBody MaterialMasterData materialMasterData,@PathVariable Long id) {
      MaterialMasterData upmaterialMasterData = materialMasterDataServiceImpl.getById(id);
      if(upmaterialMasterData != null){
        upmaterialMasterData = ObjectCopyUtils.copyProperties(materialMasterData,upmaterialMasterData,true);
      }
      return XfR.ok(materialMasterDataServiceImpl.updateById(upmaterialMasterData));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/materialmasterdatas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(materialMasterDataServiceImpl.removeById(id));
  }

  @PostMapping("/materialmasterdatas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "material_master_data");
     params.put("request", condition);

     return XfR.ok(materialMasterDataServiceImpl.querys(params));
  }

}
