package com.xforceplus.jcbyd.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcbyd.entity.PayBill;
import com.xforceplus.jcbyd.service.IPayBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-01
 */
@RestController
public class PayBillController {

  @Autowired
  private IPayBillService payBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param payBill ${table.comment}
   * @return
   */
  @GetMapping("/paybills" )
  public XfR getPayBills(XfPage page, PayBill payBill) {
    return XfR.ok(payBillServiceImpl.page(page, Wrappers.query(payBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/paybills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(payBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param payBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/paybills")
  public XfR save(@RequestBody PayBill payBill) {
     return XfR.ok(payBillServiceImpl.save(payBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param payBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/paybills/{id}")
  public XfR putUpdate(@RequestBody PayBill payBill,@PathVariable Long id) {
      payBill.setId(id);
      return XfR.ok(payBillServiceImpl.updateById(payBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param payBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/paybills/{id}")
  public XfR patchUpdate(@RequestBody PayBill payBill,@PathVariable Long id) {
      PayBill uppayBill = payBillServiceImpl.getById(id);
      if(uppayBill != null){
        uppayBill = ObjectCopyUtils.copyProperties(payBill,uppayBill,true);
      }
      return XfR.ok(payBillServiceImpl.updateById(uppayBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/paybills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(payBillServiceImpl.removeById(id));
  }

  @PostMapping("/paybills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pay_bill");
     params.put("request", condition);

     return XfR.ok(payBillServiceImpl.querys(params));
  }

}
