package com.xforceplus.jcbyd.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcbyd.entity.PurchaseOrderDetail;
import com.xforceplus.jcbyd.service.IPurchaseOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-01
 */
@RestController
public class PurchaseOrderDetailController {

  @Autowired
  private IPurchaseOrderDetailService purchaseOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaseOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/purchaseorderdetails" )
  public XfR getPurchaseOrderDetails(XfPage page, PurchaseOrderDetail purchaseOrderDetail) {
    return XfR.ok(purchaseOrderDetailServiceImpl.page(page, Wrappers.query(purchaseOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaseorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaseOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param purchaseOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/purchaseorderdetails")
  public XfR save(@RequestBody PurchaseOrderDetail purchaseOrderDetail) {
     return XfR.ok(purchaseOrderDetailServiceImpl.save(purchaseOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param purchaseOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/purchaseorderdetails/{id}")
  public XfR putUpdate(@RequestBody PurchaseOrderDetail purchaseOrderDetail,@PathVariable Long id) {
      purchaseOrderDetail.setId(id);
      return XfR.ok(purchaseOrderDetailServiceImpl.updateById(purchaseOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param purchaseOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/purchaseorderdetails/{id}")
  public XfR patchUpdate(@RequestBody PurchaseOrderDetail purchaseOrderDetail,@PathVariable Long id) {
      PurchaseOrderDetail uppurchaseOrderDetail = purchaseOrderDetailServiceImpl.getById(id);
      if(uppurchaseOrderDetail != null){
        uppurchaseOrderDetail = ObjectCopyUtils.copyProperties(purchaseOrderDetail,uppurchaseOrderDetail,true);
      }
      return XfR.ok(purchaseOrderDetailServiceImpl.updateById(uppurchaseOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaseorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaseOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/purchaseorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchase_order_detail");
     params.put("request", condition);

     return XfR.ok(purchaseOrderDetailServiceImpl.querys(params));
  }

}
