package com.xforceplus.jccainiaoocr.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 菜单系统对象
 * </p>
 *
 * @author ultraman
 * @since 2024-06-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SystemMenu implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 菜单编码
   */
  private String code;

  /**
   * 菜单名称
   */
  private String name;

  /**
   * 菜单名称拼音
   */
  private String pinyin;

  /**
   * 父菜单ID
   */
  private Long parentId;

  /**
   * 排序编号
   */
  private Long sortNo;

  /**
   * 权限码
   */
  private String resourceCode;

  /**
   * 外部链接URL
   */
  private String externalUrl;

  /**
   * 单点登录链接
   */
  private String iframeUrl;

  /**
   * 静态资源路径
   */
  @TableField("assetsPath")
  private String assetsPath;

  /**
   * 静态资源
   */
  private String assets;

  /**
   * 菜单图标
   */
  private String icon;

  /**
   * 是否启用
   */
  private Boolean isEnable;

  /**
   * 系统code
   */
  private String appCode;

  /**
   * 部署页面id
   */
  private String deployedPageId;

  /**
   * 部署页面编码
   */
  private String deployedPageCode;

  /**
   * 部署页面名称
   */
  private String deployedPageName;

  /**
   * 部署页面版本
   */
  private String deployedPageVersion;

  /**
   * 页面初始化参数
   */
  private String initParams;

  /**
   * 标签
   */
  private String tag;

  /**
   * 路由地址
   */
  private String routePath;

  /**
   * 是否首页菜单
   */
  private Boolean isFrontPage;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 状态
   */
  private String status;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("code", code);
      map.put("name", name);
      map.put("pinyin", pinyin);
      map.put("parent_id", parentId);
      map.put("sort_no", sortNo);
      map.put("resource_code", resourceCode);
      map.put("external_url", externalUrl);
      map.put("iframe_url", iframeUrl);
      map.put("assetsPath", assetsPath);
      map.put("assets", assets);
      map.put("icon", icon);
      map.put("is_enable", isEnable);
      map.put("app_code", appCode);
      map.put("deployed_page_id", deployedPageId);
      map.put("deployed_page_code", deployedPageCode);
      map.put("deployed_page_name", deployedPageName);
      map.put("deployed_page_version", deployedPageVersion);
      map.put("init_params", initParams);
      map.put("tag", tag);
      map.put("route_path", routePath);
      map.put("is_front_page", isFrontPage);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("status", status);

      return map;
  }

  public static SystemMenu fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SystemMenu entity = new SystemMenu();
    if(map.containsKey("code")) {
      Object obj = map.get("code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pinyin")) {
      Object obj = map.get("pinyin");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPinyin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parent_id")) {
      Object obj = map.get("parent_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setParentId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setParentId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setParentId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sort_no")) {
      Object obj = map.get("sort_no");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSortNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSortNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSortNo(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("resource_code")) {
      Object obj = map.get("resource_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setResourceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("external_url")) {
      Object obj = map.get("external_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExternalUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("iframe_url")) {
      Object obj = map.get("iframe_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIframeUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assetsPath")) {
      Object obj = map.get("assetsPath");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssetsPath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assets")) {
      Object obj = map.get("assets");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssets((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("icon")) {
      Object obj = map.get("icon");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIcon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_enable")) {
      Object obj = map.get("is_enable");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsEnable((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsEnable(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("app_code")) {
      Object obj = map.get("app_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deployed_page_id")) {
      Object obj = map.get("deployed_page_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeployedPageId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deployed_page_code")) {
      Object obj = map.get("deployed_page_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeployedPageCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deployed_page_name")) {
      Object obj = map.get("deployed_page_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeployedPageName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deployed_page_version")) {
      Object obj = map.get("deployed_page_version");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeployedPageVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("init_params")) {
      Object obj = map.get("init_params");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInitParams((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tag")) {
      Object obj = map.get("tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("route_path")) {
      Object obj = map.get("route_path");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRoutePath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_front_page")) {
      Object obj = map.get("is_front_page");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsFrontPage((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsFrontPage(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("code")) {
      Object obj = map.get("code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pinyin")) {
      Object obj = map.get("pinyin");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPinyin((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("parent_id")) {
      Object obj = map.get("parent_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setParentId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setParentId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setParentId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sort_no")) {
      Object obj = map.get("sort_no");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSortNo((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSortNo(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSortNo(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("resource_code")) {
      Object obj = map.get("resource_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setResourceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("external_url")) {
      Object obj = map.get("external_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExternalUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("iframe_url")) {
      Object obj = map.get("iframe_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIframeUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("assetsPath")) {
      Object obj = map.get("assetsPath");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssetsPath((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("assets")) {
      Object obj = map.get("assets");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssets((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("icon")) {
      Object obj = map.get("icon");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIcon((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_enable")) {
      Object obj = map.get("is_enable");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsEnable((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsEnable(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("app_code")) {
      Object obj = map.get("app_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAppCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deployed_page_id")) {
      Object obj = map.get("deployed_page_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeployedPageId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deployed_page_code")) {
      Object obj = map.get("deployed_page_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeployedPageCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deployed_page_name")) {
      Object obj = map.get("deployed_page_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeployedPageName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deployed_page_version")) {
      Object obj = map.get("deployed_page_version");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeployedPageVersion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("init_params")) {
      Object obj = map.get("init_params");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInitParams((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tag")) {
      Object obj = map.get("tag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("route_path")) {
      Object obj = map.get("route_path");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRoutePath((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_front_page")) {
      Object obj = map.get("is_front_page");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsFrontPage((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsFrontPage(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
  }
}
