package com.xforceplus.jccass.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-04-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MatchRules implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 购方税号
   */
  private String buyerTaxNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 规则名称
   */
  private String name;

  /**
   * 单据配单计算依据
   */
  private String billMatchAccordStatus;

  /**
   * 配单明细匹配条件
   */
  private String billMatchDetailStatus;

  /**
   * 是否启用自动匹配
   */
  private String autoMatchStatus;

  /**
   * 自动匹配优先级规则
   */
  private String autoMatchPriorityStatus;

  /**
   * 是否自动上传票易通平台
   */
  private String autoUploadPlatformStatus;

  /**
   * 规则是否启用
   */
  private String ruleUseStatus;

  /**
   * 业务单类型
   */
  private String billType;

  /**
   * 明细容差
   */
  private BigDecimal detailTolerance;

  /**
   * 单据容差
   */
  private BigDecimal billTolerance;

  /**
   * 购方名称
   */
  private String buyerName;

  /**
   * 销方税号
   */
  private String sellerTaxNo;

  /**
   * 是否需要审核确认
   */
  private String checkConfirmStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("buyer_tax_no", buyerTaxNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("name", name);
      map.put("bill_match_accord_status", billMatchAccordStatus);
      map.put("bill_match_detail_status", billMatchDetailStatus);
      map.put("auto_match_status", autoMatchStatus);
      map.put("auto_match_priority_status", autoMatchPriorityStatus);
      map.put("auto_upload_platform_status", autoUploadPlatformStatus);
      map.put("rule_use_status", ruleUseStatus);
      map.put("bill_type", billType);
      map.put("detail_tolerance", detailTolerance);
      map.put("bill_tolerance", billTolerance);
      map.put("buyer_name", buyerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("check_confirm_status", checkConfirmStatus);
      return map;
  }

  public static MatchRules fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MatchRules entity = new MatchRules();
    if(map.containsKey("buyer_tax_no")) {
      Object obj = map.get("buyer_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_match_accord_status")) {
      Object obj = map.get("bill_match_accord_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillMatchAccordStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_match_detail_status")) {
      Object obj = map.get("bill_match_detail_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillMatchDetailStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auto_match_status")) {
      Object obj = map.get("auto_match_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAutoMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auto_match_priority_status")) {
      Object obj = map.get("auto_match_priority_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAutoMatchPriorityStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auto_upload_platform_status")) {
      Object obj = map.get("auto_upload_platform_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAutoUploadPlatformStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rule_use_status")) {
      Object obj = map.get("rule_use_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRuleUseStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_type")) {
      Object obj = map.get("bill_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detail_tolerance")) {
      Object obj = map.get("detail_tolerance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDetailTolerance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDetailTolerance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDetailTolerance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDetailTolerance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDetailTolerance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_tolerance")) {
      Object obj = map.get("bill_tolerance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillTolerance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillTolerance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillTolerance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setBillTolerance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillTolerance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyer_name")) {
      Object obj = map.get("buyer_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_confirm_status")) {
      Object obj = map.get("check_confirm_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckConfirmStatus((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("buyer_tax_no")) {
      Object obj = map.get("buyer_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_match_accord_status")) {
      Object obj = map.get("bill_match_accord_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillMatchAccordStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_match_detail_status")) {
      Object obj = map.get("bill_match_detail_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillMatchDetailStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auto_match_status")) {
      Object obj = map.get("auto_match_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAutoMatchStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auto_match_priority_status")) {
      Object obj = map.get("auto_match_priority_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAutoMatchPriorityStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auto_upload_platform_status")) {
      Object obj = map.get("auto_upload_platform_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAutoUploadPlatformStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rule_use_status")) {
      Object obj = map.get("rule_use_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRuleUseStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_type")) {
      Object obj = map.get("bill_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("detail_tolerance")) {
      Object obj = map.get("detail_tolerance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDetailTolerance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDetailTolerance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDetailTolerance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setDetailTolerance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDetailTolerance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bill_tolerance")) {
      Object obj = map.get("bill_tolerance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBillTolerance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBillTolerance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBillTolerance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setBillTolerance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBillTolerance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("buyer_name")) {
      Object obj = map.get("buyer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_confirm_status")) {
      Object obj = map.get("check_confirm_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckConfirmStatus((String)obj);
        }
      } else {
      }
    }
  }
}
