package com.xforceplus.jccass.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 规则类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-23
 */
public enum RuleType {

    DEFAULT("default", "默认规则"),
    SINGLE("single", "单一规则");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    RuleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RuleType fromCode(String code){
        switch(code) {
            case "default":
                return DEFAULT;
            case "single":
                return SINGLE;
            default:
                return null;
        }
    }
}
