package com.xforceplus.jccass.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Bill implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务单号
   */
  private String billNo;

  /**
   * 匹配状态
   */
  private String matchStatus;

  /**
   * 明细数量
   */
  private Long detailCount;

  /**
   * 未匹配数量
   */
  private String unmatchDetailCount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;

  /**
   * 已匹配含税金额
   */
  private BigDecimal matchAmountWithTax;

  /**
   * 销方税号
   */
  private String sellerTaxNo;

  /**
   * 匹配数量
   */
  private Long matchDetailCount;

  /**
   * 未匹配含税金额
   */
  private String unmatchAmountWithTax;

  /**
   * 购方税号
   */
  private String buyerTaxNo;

  /**
   * 销方名称
   */
  private String sellerName;

  /**
   * 购方名称
   */
  private String buyerName;

  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;

  /**
   * 已匹配不含税金额
   */
  private BigDecimal matchAmountWithoutTax;

  /**
   * 未匹配不含税金额
   */
  private String unmatchAmountWithoutTax;

  /**
   * 原始业务单信息
   */
  private String rawBillInfo;

  /**
   * 确认状态
   */
  private String confirmStatus;

  /**
   * 锁定状态
   */
  private String lockStatus;

  /**
   * 账单周期
   */
  private String ext5;

  /**
   * 店铺名称
   */
  private String ext2;

  /**
   * 税额
   */
  private BigDecimal taxAmount;

  /**
   * 账单类型
   */
  private String ext1;

  /**
   * 单据来源
   */
  private String source;

  /**
   * 对项标识
   */
  private String ext3;

  /**
   * 备注
   */
  private String remark;

  /**
   * 购方编号
   */
  private String buyerNo;

  /**
   * 销方编号
   */
  private String sellerNo;

  /**
   * 业务单类型
   */
  private String billType;

  /**
   * 发票类型
   */
  private String invoiceKind;

  /**
   * 国税发票来源
   */
  private String taxInvoiceSource;

  /**
   * 账单编号
   */
  private String ext4;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bill_no", billNo);
      map.put("match_status", matchStatus);
      map.put("detail_count", detailCount);
      map.put("unmatch_detail_count", unmatchDetailCount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("amount_with_tax", amountWithTax);
      map.put("match_amount_with_tax", matchAmountWithTax);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("match_detail_count", matchDetailCount);
      map.put("unmatch_amount_with_tax", unmatchAmountWithTax);
      map.put("buyer_tax_no", buyerTaxNo);
      map.put("seller_name", sellerName);
      map.put("buyer_name", buyerName);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("match_amount_without_tax", matchAmountWithoutTax);
      map.put("unmatch_amount_without_tax", unmatchAmountWithoutTax);
      map.put("raw_bill_info", rawBillInfo);
      map.put("confirm_status", confirmStatus);
      map.put("lock_status", lockStatus);
      map.put("ext5", ext5);
      map.put("ext2", ext2);
      map.put("tax_amount", taxAmount);
      map.put("ext1", ext1);
      map.put("source", source);
      map.put("ext3", ext3);
      map.put("remark", remark);
      map.put("buyer_no", buyerNo);
      map.put("seller_no", sellerNo);
      map.put("bill_type", billType);
      map.put("invoice_kind", invoiceKind);
      map.put("tax_invoice_source", taxInvoiceSource);
      map.put("ext4", ext4);
      return map;
  }

  public static Bill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Bill entity = new Bill();
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detail_count")) {
      Object obj = map.get("detail_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDetailCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setDetailCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDetailCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("unmatch_detail_count")) {
      Object obj = map.get("unmatch_detail_count");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnmatchDetailCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("match_amount_with_tax")) {
      Object obj = map.get("match_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMatchAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMatchAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMatchAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setMatchAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMatchAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("match_detail_count")) {
      Object obj = map.get("match_detail_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMatchDetailCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setMatchDetailCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMatchDetailCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("unmatch_amount_with_tax")) {
      Object obj = map.get("unmatch_amount_with_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnmatchAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_tax_no")) {
      Object obj = map.get("buyer_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_name")) {
      Object obj = map.get("buyer_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("match_amount_without_tax")) {
      Object obj = map.get("match_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMatchAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMatchAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMatchAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setMatchAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMatchAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unmatch_amount_without_tax")) {
      Object obj = map.get("unmatch_amount_without_tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnmatchAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("raw_bill_info")) {
      Object obj = map.get("raw_bill_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRawBillInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("confirm_status")) {
      Object obj = map.get("confirm_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConfirmStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lock_status")) {
      Object obj = map.get("lock_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLockStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_no")) {
      Object obj = map.get("buyer_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBuyerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_type")) {
      Object obj = map.get("bill_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_kind")) {
      Object obj = map.get("invoice_kind");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_invoice_source")) {
      Object obj = map.get("tax_invoice_source");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("match_status")) {
      Object obj = map.get("match_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatchStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("detail_count")) {
      Object obj = map.get("detail_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDetailCount((Long)obj);
        } else if(obj instanceof String) {
          this.setDetailCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDetailCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("unmatch_detail_count")) {
      Object obj = map.get("unmatch_detail_count");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnmatchDetailCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("match_amount_with_tax")) {
      Object obj = map.get("match_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setMatchAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setMatchAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setMatchAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setMatchAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setMatchAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("match_detail_count")) {
      Object obj = map.get("match_detail_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMatchDetailCount((Long)obj);
        } else if(obj instanceof String) {
          this.setMatchDetailCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMatchDetailCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("unmatch_amount_with_tax")) {
      Object obj = map.get("unmatch_amount_with_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnmatchAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_tax_no")) {
      Object obj = map.get("buyer_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_name")) {
      Object obj = map.get("buyer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("match_amount_without_tax")) {
      Object obj = map.get("match_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setMatchAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setMatchAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setMatchAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setMatchAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setMatchAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unmatch_amount_without_tax")) {
      Object obj = map.get("unmatch_amount_without_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnmatchAmountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("raw_bill_info")) {
      Object obj = map.get("raw_bill_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRawBillInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("confirm_status")) {
      Object obj = map.get("confirm_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfirmStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lock_status")) {
      Object obj = map.get("lock_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLockStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_no")) {
      Object obj = map.get("buyer_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_no")) {
      Object obj = map.get("seller_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_type")) {
      Object obj = map.get("bill_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_kind")) {
      Object obj = map.get("invoice_kind");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceKind((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_invoice_source")) {
      Object obj = map.get("tax_invoice_source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxInvoiceSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
  }
}
