package com.xforceplus.jccass.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 导入商品记录状态
 * </p>
 *
 * @author ultraman
 * @since 2023-06-29
 */
public enum ImportGoodInfoStatus {

    _2("2", "处理中"),
    _3("3", "全部失败"),
    _4("4", "部分成功"),
    _5("5", "全部成功");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ImportGoodInfoStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImportGoodInfoStatus fromCode(String code){
        switch(code) {
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
