package com.xforceplus.jccass.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 库存业务原因
 * </p>
 *
 * @author ultraman
 * @since 2023-04-06
 */
public enum InventoryServiceReason {

    _1("1", "发票导入"),
    _2("2", "手动录入"),
    _3("3", "配单出库"),
    _4("4", "发票核销手动调整"),
    _5("5", "取消-配单出库"),
    _6("6", "负数明细配单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InventoryServiceReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InventoryServiceReason fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
