package com.xforceplus.jccass.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 配单明细匹配条件
 * </p>
 *
 * @author ultraman
 * @since 2023-04-07
 */
public enum BillMatchDetailStatus {

    _1("1", "销方税号"),
    _2("2", "销方名称"),
    _3("3", "商品名称"),
    _4("4", "规格型号"),
    _5("5", "单位"),
    _6("6", "单价"),
    _7("7", "税编简称"),
    _8("8", "税编"),
    _9("9", "税率");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillMatchDetailStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillMatchDetailStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
