package com.xforceplus.jccass.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2023-04-10
 */
public enum InvoiceType {

    C("c", "普票"),
    QS("qs", "全电"),
    CE("ce", "ce"),
    S("s", "s"),
    SE("se", "se"),
    QC("qc", "qc"),
    CZ("cz", "cz"),
    SZ("sz", "sz"),
    JU("ju", "ju"),
    V("v", "v"),
    T("t", "t"),
    CT("ct", "ct"),
    VS("vs", "vs"),
    CP("cp", "cp"),
    CD("cd", "cd");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "c":
                return C;
            case "qs":
                return QS;
            case "ce":
                return CE;
            case "s":
                return S;
            case "se":
                return SE;
            case "qc":
                return QC;
            case "cz":
                return CZ;
            case "sz":
                return SZ;
            case "ju":
                return JU;
            case "v":
                return V;
            case "t":
                return T;
            case "ct":
                return CT;
            case "vs":
                return VS;
            case "cp":
                return CP;
            case "cd":
                return CD;
            default:
                return null;
        }
    }
}
