package com.xforceplus.jccass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccass.entity.TaxCode;
import com.xforceplus.jccass.service.ITaxCodeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-11
 */
@RestController
public class TaxCodeController {

  @Autowired
  private ITaxCodeService taxCodeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxCode ${table.comment}
   * @return
   */
  @GetMapping("/taxcodes" )
  public XfR getTaxCodes(XfPage page, TaxCode taxCode) {
    return XfR.ok(taxCodeServiceImpl.page(page, Wrappers.query(taxCode)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxcodes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxCodeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxCode ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxcodes")
  public XfR save(@RequestBody TaxCode taxCode) {
     return XfR.ok(taxCodeServiceImpl.save(taxCode));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxCode ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxcodes/{id}")
  public XfR putUpdate(@RequestBody TaxCode taxCode,@PathVariable Long id) {
      taxCode.setId(id);
      return XfR.ok(taxCodeServiceImpl.updateById(taxCode));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxCode ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxcodes/{id}")
  public XfR patchUpdate(@RequestBody TaxCode taxCode,@PathVariable Long id) {
      TaxCode uptaxCode = taxCodeServiceImpl.getById(id);
      if(uptaxCode != null){
        uptaxCode = ObjectCopyUtils.copyProperties(taxCode,uptaxCode,true);
      }
      return XfR.ok(taxCodeServiceImpl.updateById(uptaxCode));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxcodes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxCodeServiceImpl.removeById(id));
  }

  @PostMapping("/taxcodes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_code");
     params.put("request", condition);

     return XfR.ok(taxCodeServiceImpl.querys(params));
  }

}
