package com.xforceplus.jccass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccass.entity.ImportInvoice;
import com.xforceplus.jccass.service.IImportInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-05-25
 */
@RestController
public class ImportInvoiceController {

  @Autowired
  private IImportInvoiceService importInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param importInvoice ${table.comment}
   * @return
   */
  @GetMapping("/importinvoices" )
  public XfR getImportInvoices(XfPage page, ImportInvoice importInvoice) {
    return XfR.ok(importInvoiceServiceImpl.page(page, Wrappers.query(importInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/importinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(importInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param importInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/importinvoices")
  public XfR save(@RequestBody ImportInvoice importInvoice) {
     return XfR.ok(importInvoiceServiceImpl.save(importInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param importInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/importinvoices/{id}")
  public XfR putUpdate(@RequestBody ImportInvoice importInvoice,@PathVariable Long id) {
      importInvoice.setId(id);
      return XfR.ok(importInvoiceServiceImpl.updateById(importInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param importInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/importinvoices/{id}")
  public XfR patchUpdate(@RequestBody ImportInvoice importInvoice,@PathVariable Long id) {
      ImportInvoice upimportInvoice = importInvoiceServiceImpl.getById(id);
      if(upimportInvoice != null){
        upimportInvoice = ObjectCopyUtils.copyProperties(importInvoice,upimportInvoice,true);
      }
      return XfR.ok(importInvoiceServiceImpl.updateById(upimportInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/importinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(importInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/importinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "import_invoice");
     params.put("request", condition);

     return XfR.ok(importInvoiceServiceImpl.querys(params));
  }

}
