package com.xforceplus.jccass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccass.entity.ImportGoodsInfoDetail;
import com.xforceplus.jccass.service.IImportGoodsInfoDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-14
 */
@RestController
public class ImportGoodsInfoDetailController {

  @Autowired
  private IImportGoodsInfoDetailService importGoodsInfoDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param importGoodsInfoDetail ${table.comment}
   * @return
   */
  @GetMapping("/importgoodsinfodetails" )
  public XfR getImportGoodsInfoDetails(XfPage page, ImportGoodsInfoDetail importGoodsInfoDetail) {
    return XfR.ok(importGoodsInfoDetailServiceImpl.page(page, Wrappers.query(importGoodsInfoDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/importgoodsinfodetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(importGoodsInfoDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param importGoodsInfoDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/importgoodsinfodetails")
  public XfR save(@RequestBody ImportGoodsInfoDetail importGoodsInfoDetail) {
     return XfR.ok(importGoodsInfoDetailServiceImpl.save(importGoodsInfoDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param importGoodsInfoDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/importgoodsinfodetails/{id}")
  public XfR putUpdate(@RequestBody ImportGoodsInfoDetail importGoodsInfoDetail,@PathVariable Long id) {
      importGoodsInfoDetail.setId(id);
      return XfR.ok(importGoodsInfoDetailServiceImpl.updateById(importGoodsInfoDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param importGoodsInfoDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/importgoodsinfodetails/{id}")
  public XfR patchUpdate(@RequestBody ImportGoodsInfoDetail importGoodsInfoDetail,@PathVariable Long id) {
      ImportGoodsInfoDetail upimportGoodsInfoDetail = importGoodsInfoDetailServiceImpl.getById(id);
      if(upimportGoodsInfoDetail != null){
        upimportGoodsInfoDetail = ObjectCopyUtils.copyProperties(importGoodsInfoDetail,upimportGoodsInfoDetail,true);
      }
      return XfR.ok(importGoodsInfoDetailServiceImpl.updateById(upimportGoodsInfoDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/importgoodsinfodetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(importGoodsInfoDetailServiceImpl.removeById(id));
  }

  @PostMapping("/importgoodsinfodetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "import_goods_info_detail");
     params.put("request", condition);

     return XfR.ok(importGoodsInfoDetailServiceImpl.querys(params));
  }

}
