package com.xforceplus.jccass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccass.entity.ImportInventoryDetailInfo;
import com.xforceplus.jccass.service.IImportInventoryDetailInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-17
 */
@RestController
public class ImportInventoryDetailInfoController {

  @Autowired
  private IImportInventoryDetailInfoService importInventoryDetailInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param importInventoryDetailInfo ${table.comment}
   * @return
   */
  @GetMapping("/importinventorydetailinfos" )
  public XfR getImportInventoryDetailInfos(XfPage page, ImportInventoryDetailInfo importInventoryDetailInfo) {
    return XfR.ok(importInventoryDetailInfoServiceImpl.page(page, Wrappers.query(importInventoryDetailInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/importinventorydetailinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(importInventoryDetailInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param importInventoryDetailInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/importinventorydetailinfos")
  public XfR save(@RequestBody ImportInventoryDetailInfo importInventoryDetailInfo) {
     return XfR.ok(importInventoryDetailInfoServiceImpl.save(importInventoryDetailInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param importInventoryDetailInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/importinventorydetailinfos/{id}")
  public XfR putUpdate(@RequestBody ImportInventoryDetailInfo importInventoryDetailInfo,@PathVariable Long id) {
      importInventoryDetailInfo.setId(id);
      return XfR.ok(importInventoryDetailInfoServiceImpl.updateById(importInventoryDetailInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param importInventoryDetailInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/importinventorydetailinfos/{id}")
  public XfR patchUpdate(@RequestBody ImportInventoryDetailInfo importInventoryDetailInfo,@PathVariable Long id) {
      ImportInventoryDetailInfo upimportInventoryDetailInfo = importInventoryDetailInfoServiceImpl.getById(id);
      if(upimportInventoryDetailInfo != null){
        upimportInventoryDetailInfo = ObjectCopyUtils.copyProperties(importInventoryDetailInfo,upimportInventoryDetailInfo,true);
      }
      return XfR.ok(importInventoryDetailInfoServiceImpl.updateById(upimportInventoryDetailInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/importinventorydetailinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(importInventoryDetailInfoServiceImpl.removeById(id));
  }

  @PostMapping("/importinventorydetailinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "import_inventory_detail_info");
     params.put("request", condition);

     return XfR.ok(importInventoryDetailInfoServiceImpl.querys(params));
  }

}
