package com.xforceplus.jccass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccass.entity.InventoryMatch;
import com.xforceplus.jccass.service.IInventoryMatchService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-17
 */
@RestController
public class InventoryMatchController {

  @Autowired
  private IInventoryMatchService inventoryMatchServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inventoryMatch ${table.comment}
   * @return
   */
  @GetMapping("/inventorymatchs" )
  public XfR getInventoryMatchs(XfPage page, InventoryMatch inventoryMatch) {
    return XfR.ok(inventoryMatchServiceImpl.page(page, Wrappers.query(inventoryMatch)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/inventorymatchs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(inventoryMatchServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param inventoryMatch ${table.comment}
   * @return XfR
   */
  @PostMapping("/inventorymatchs")
  public XfR save(@RequestBody InventoryMatch inventoryMatch) {
     return XfR.ok(inventoryMatchServiceImpl.save(inventoryMatch));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param inventoryMatch ${table.comment}
   * @return XfR
   */
  @PutMapping("/inventorymatchs/{id}")
  public XfR putUpdate(@RequestBody InventoryMatch inventoryMatch,@PathVariable Long id) {
      inventoryMatch.setId(id);
      return XfR.ok(inventoryMatchServiceImpl.updateById(inventoryMatch));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param inventoryMatch ${table.comment}
   * @return XfR
   */
  @PatchMapping("/inventorymatchs/{id}")
  public XfR patchUpdate(@RequestBody InventoryMatch inventoryMatch,@PathVariable Long id) {
      InventoryMatch upinventoryMatch = inventoryMatchServiceImpl.getById(id);
      if(upinventoryMatch != null){
        upinventoryMatch = ObjectCopyUtils.copyProperties(inventoryMatch,upinventoryMatch,true);
      }
      return XfR.ok(inventoryMatchServiceImpl.updateById(upinventoryMatch));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/inventorymatchs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(inventoryMatchServiceImpl.removeById(id));
  }

  @PostMapping("/inventorymatchs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inventory_match");
     params.put("request", condition);

     return XfR.ok(inventoryMatchServiceImpl.querys(params));
  }

}
