package com.xforceplus.jccass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccass.entity.OptLog;
import com.xforceplus.jccass.service.IOptLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-17
 */
@RestController
public class OptLogController {

  @Autowired
  private IOptLogService optLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param optLog ${table.comment}
   * @return
   */
  @GetMapping("/optlogs" )
  public XfR getOptLogs(XfPage page, OptLog optLog) {
    return XfR.ok(optLogServiceImpl.page(page, Wrappers.query(optLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/optlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(optLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param optLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/optlogs")
  public XfR save(@RequestBody OptLog optLog) {
     return XfR.ok(optLogServiceImpl.save(optLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param optLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/optlogs/{id}")
  public XfR putUpdate(@RequestBody OptLog optLog,@PathVariable Long id) {
      optLog.setId(id);
      return XfR.ok(optLogServiceImpl.updateById(optLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param optLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/optlogs/{id}")
  public XfR patchUpdate(@RequestBody OptLog optLog,@PathVariable Long id) {
      OptLog upoptLog = optLogServiceImpl.getById(id);
      if(upoptLog != null){
        upoptLog = ObjectCopyUtils.copyProperties(optLog,upoptLog,true);
      }
      return XfR.ok(optLogServiceImpl.updateById(upoptLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/optlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(optLogServiceImpl.removeById(id));
  }

  @PostMapping("/optlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "opt_log");
     params.put("request", condition);

     return XfR.ok(optLogServiceImpl.querys(params));
  }

}
