package com.xforceplus.jccass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccass.entity.ImportGoodsInfo;
import com.xforceplus.jccass.service.IImportGoodsInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-21
 */
@RestController
public class ImportGoodsInfoController {

  @Autowired
  private IImportGoodsInfoService importGoodsInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param importGoodsInfo ${table.comment}
   * @return
   */
  @GetMapping("/importgoodsinfos" )
  public XfR getImportGoodsInfos(XfPage page, ImportGoodsInfo importGoodsInfo) {
    return XfR.ok(importGoodsInfoServiceImpl.page(page, Wrappers.query(importGoodsInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/importgoodsinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(importGoodsInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param importGoodsInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/importgoodsinfos")
  public XfR save(@RequestBody ImportGoodsInfo importGoodsInfo) {
     return XfR.ok(importGoodsInfoServiceImpl.save(importGoodsInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param importGoodsInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/importgoodsinfos/{id}")
  public XfR putUpdate(@RequestBody ImportGoodsInfo importGoodsInfo,@PathVariable Long id) {
      importGoodsInfo.setId(id);
      return XfR.ok(importGoodsInfoServiceImpl.updateById(importGoodsInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param importGoodsInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/importgoodsinfos/{id}")
  public XfR patchUpdate(@RequestBody ImportGoodsInfo importGoodsInfo,@PathVariable Long id) {
      ImportGoodsInfo upimportGoodsInfo = importGoodsInfoServiceImpl.getById(id);
      if(upimportGoodsInfo != null){
        upimportGoodsInfo = ObjectCopyUtils.copyProperties(importGoodsInfo,upimportGoodsInfo,true);
      }
      return XfR.ok(importGoodsInfoServiceImpl.updateById(upimportGoodsInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/importgoodsinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(importGoodsInfoServiceImpl.removeById(id));
  }

  @PostMapping("/importgoodsinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "import_goods_info");
     params.put("request", condition);

     return XfR.ok(importGoodsInfoServiceImpl.querys(params));
  }

}
