package com.xforceplus.jccass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccass.entity.InventoryQuatitySum;
import com.xforceplus.jccass.service.IInventoryQuatitySumService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-21
 */
@RestController
public class InventoryQuatitySumController {

  @Autowired
  private IInventoryQuatitySumService inventoryQuatitySumServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inventoryQuatitySum ${table.comment}
   * @return
   */
  @GetMapping("/inventoryquatitysums" )
  public XfR getInventoryQuatitySums(XfPage page, InventoryQuatitySum inventoryQuatitySum) {
    return XfR.ok(inventoryQuatitySumServiceImpl.page(page, Wrappers.query(inventoryQuatitySum)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/inventoryquatitysums/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(inventoryQuatitySumServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param inventoryQuatitySum ${table.comment}
   * @return XfR
   */
  @PostMapping("/inventoryquatitysums")
  public XfR save(@RequestBody InventoryQuatitySum inventoryQuatitySum) {
     return XfR.ok(inventoryQuatitySumServiceImpl.save(inventoryQuatitySum));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param inventoryQuatitySum ${table.comment}
   * @return XfR
   */
  @PutMapping("/inventoryquatitysums/{id}")
  public XfR putUpdate(@RequestBody InventoryQuatitySum inventoryQuatitySum,@PathVariable Long id) {
      inventoryQuatitySum.setId(id);
      return XfR.ok(inventoryQuatitySumServiceImpl.updateById(inventoryQuatitySum));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param inventoryQuatitySum ${table.comment}
   * @return XfR
   */
  @PatchMapping("/inventoryquatitysums/{id}")
  public XfR patchUpdate(@RequestBody InventoryQuatitySum inventoryQuatitySum,@PathVariable Long id) {
      InventoryQuatitySum upinventoryQuatitySum = inventoryQuatitySumServiceImpl.getById(id);
      if(upinventoryQuatitySum != null){
        upinventoryQuatitySum = ObjectCopyUtils.copyProperties(inventoryQuatitySum,upinventoryQuatitySum,true);
      }
      return XfR.ok(inventoryQuatitySumServiceImpl.updateById(upinventoryQuatitySum));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/inventoryquatitysums/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(inventoryQuatitySumServiceImpl.removeById(id));
  }

  @PostMapping("/inventoryquatitysums/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inventory_quatity_sum");
     params.put("request", condition);

     return XfR.ok(inventoryQuatitySumServiceImpl.querys(params));
  }

}
