package com.xforceplus.jccass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jccass.entity.MatchRules;
import com.xforceplus.jccass.service.IMatchRulesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-04
 */
@RestController
public class MatchRulesController {

  @Autowired
  private IMatchRulesService matchRulesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param matchRules ${table.comment}
   * @return
   */
  @GetMapping("/matchruless" )
  public XfR getMatchRuless(XfPage page, MatchRules matchRules) {
    return XfR.ok(matchRulesServiceImpl.page(page, Wrappers.query(matchRules)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/matchruless/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(matchRulesServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param matchRules ${table.comment}
   * @return XfR
   */
  @PostMapping("/matchruless")
  public XfR save(@RequestBody MatchRules matchRules) {
     return XfR.ok(matchRulesServiceImpl.save(matchRules));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param matchRules ${table.comment}
   * @return XfR
   */
  @PutMapping("/matchruless/{id}")
  public XfR putUpdate(@RequestBody MatchRules matchRules,@PathVariable Long id) {
      matchRules.setId(id);
      return XfR.ok(matchRulesServiceImpl.updateById(matchRules));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param matchRules ${table.comment}
   * @return XfR
   */
  @PatchMapping("/matchruless/{id}")
  public XfR patchUpdate(@RequestBody MatchRules matchRules,@PathVariable Long id) {
      MatchRules upmatchRules = matchRulesServiceImpl.getById(id);
      if(upmatchRules != null){
        upmatchRules = ObjectCopyUtils.copyProperties(matchRules,upmatchRules,true);
      }
      return XfR.ok(matchRulesServiceImpl.updateById(upmatchRules));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/matchruless/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(matchRulesServiceImpl.removeById(id));
  }

  @PostMapping("/matchruless/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "match_rules");
     params.put("request", condition);

     return XfR.ok(matchRulesServiceImpl.querys(params));
  }

}
