package com.xforceplus.jcchagee.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-09-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AccountBalanceTable implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 属地表id
   */
  private String tableId;

  /**
   * 组织编码（与“税号”两者必填一个）
   */
  private String orgCode;

  /**
   * 税号（与“组织编码”两者必填一个）
   */
  private String socialCreditCode;

  /**
   * 报表期间年
   */
  private String taxYear;

  /**
   * 报表期间月：01-12季：Q1~Q4年/审计版：13/Y12
   */
  private String taxPeriod;

  /**
   * 参考《报表类型》
   */
  private Long mappingType;

  /**
   * 数据范围：0单体；1合并；21分支机构/分公司；
   */
  private Long label;

  /**
   * 关账=1\n未关账=0
   */
  private Long isCloseAacount;

  /**
   * 0-追加、1-覆盖
   */
  private Long isCover;

  /**
   * 科目编码
   */
  private String accountCode;

  /**
   * 科目名称
   */
  private String accountName;

  /**
   * 期初余额-借方
   */
  private BigDecimal openingDebit;

  /**
   * 期初余额-贷方
   */
  private BigDecimal openingCredit;

  /**
   * 本期发生-借方
   */
  private BigDecimal currentDebit;

  /**
   * 本期发生-贷方
   */
  private BigDecimal currentCredit;

  /**
   * 本年累计-借方
   */
  private BigDecimal yearDebit;

  /**
   * 本年累计-贷方
   */
  private BigDecimal yearCredit;

  /**
   * 期末余额-借方
   */
  private BigDecimal closingDebit;

  /**
   * 期末余额-贷方
   */
  private BigDecimal closingCredit;

  /**
   * 数据更新时间戳
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lastModifyTime;

  /**
   * 数据批次
   */
  private String batchNumber;

  /**
   * 已同步=1\n未同步=0；默认值0
   */
  private Long isUpload;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("table_id", tableId);
      map.put("org_code", orgCode);
      map.put("social_credit_code", socialCreditCode);
      map.put("tax_year", taxYear);
      map.put("tax_period", taxPeriod);
      map.put("mapping_type", mappingType);
      map.put("label", label);
      map.put("is_close_aacount", isCloseAacount);
      map.put("is_cover", isCover);
      map.put("account_code", accountCode);
      map.put("account_name", accountName);
      map.put("opening_debit", openingDebit);
      map.put("opening_credit", openingCredit);
      map.put("current_debit", currentDebit);
      map.put("current_credit", currentCredit);
      map.put("year_debit", yearDebit);
      map.put("year_credit", yearCredit);
      map.put("closing_debit", closingDebit);
      map.put("closing_credit", closingCredit);
      map.put("last_modify_time", BocpGenUtils.toTimestamp(lastModifyTime));
      map.put("batch_number", batchNumber);
      map.put("is_upload", isUpload);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static AccountBalanceTable fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    AccountBalanceTable entity = new AccountBalanceTable();
    if(map.containsKey("table_id")) {
      Object obj = map.get("table_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTableId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("social_credit_code")) {
      Object obj = map.get("social_credit_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSocialCreditCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_year")) {
      Object obj = map.get("tax_year");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_period")) {
      Object obj = map.get("tax_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mapping_type")) {
      Object obj = map.get("mapping_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMappingType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMappingType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMappingType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("label")) {
      Object obj = map.get("label");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLabel((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLabel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLabel(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_close_aacount")) {
      Object obj = map.get("is_close_aacount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsCloseAacount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsCloseAacount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsCloseAacount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_cover")) {
      Object obj = map.get("is_cover");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsCover((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsCover(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsCover(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("account_code")) {
      Object obj = map.get("account_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_name")) {
      Object obj = map.get("account_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opening_debit")) {
      Object obj = map.get("opening_debit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOpeningDebit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOpeningDebit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOpeningDebit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOpeningDebit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOpeningDebit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("opening_credit")) {
      Object obj = map.get("opening_credit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOpeningCredit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOpeningCredit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOpeningCredit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOpeningCredit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOpeningCredit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("current_debit")) {
      Object obj = map.get("current_debit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentDebit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentDebit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentDebit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCurrentDebit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentDebit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("current_credit")) {
      Object obj = map.get("current_credit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentCredit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentCredit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentCredit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCurrentCredit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentCredit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("year_debit")) {
      Object obj = map.get("year_debit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setYearDebit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setYearDebit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setYearDebit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setYearDebit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setYearDebit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("year_credit")) {
      Object obj = map.get("year_credit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setYearCredit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setYearCredit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setYearCredit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setYearCredit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setYearCredit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("closing_debit")) {
      Object obj = map.get("closing_debit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setClosingDebit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setClosingDebit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setClosingDebit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setClosingDebit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setClosingDebit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("closing_credit")) {
      Object obj = map.get("closing_credit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setClosingCredit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setClosingCredit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setClosingCredit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setClosingCredit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setClosingCredit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_modify_time")) {
      Object obj = map.get("last_modify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLastModifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLastModifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastModifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLastModifyTime(null);
      }
    }
    if(map.containsKey("batch_number")) {
      Object obj = map.get("batch_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_upload")) {
      Object obj = map.get("is_upload");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsUpload((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsUpload(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsUpload(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("table_id")) {
      Object obj = map.get("table_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTableId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("social_credit_code")) {
      Object obj = map.get("social_credit_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSocialCreditCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_year")) {
      Object obj = map.get("tax_year");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxYear((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_period")) {
      Object obj = map.get("tax_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mapping_type")) {
      Object obj = map.get("mapping_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMappingType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMappingType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMappingType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("label")) {
      Object obj = map.get("label");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLabel((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLabel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLabel(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("is_close_aacount")) {
      Object obj = map.get("is_close_aacount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsCloseAacount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsCloseAacount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsCloseAacount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("is_cover")) {
      Object obj = map.get("is_cover");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsCover((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsCover(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsCover(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("account_code")) {
      Object obj = map.get("account_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_name")) {
      Object obj = map.get("account_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("opening_debit")) {
      Object obj = map.get("opening_debit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOpeningDebit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOpeningDebit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOpeningDebit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOpeningDebit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOpeningDebit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("opening_credit")) {
      Object obj = map.get("opening_credit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOpeningCredit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOpeningCredit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOpeningCredit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOpeningCredit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOpeningCredit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("current_debit")) {
      Object obj = map.get("current_debit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCurrentDebit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCurrentDebit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCurrentDebit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCurrentDebit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCurrentDebit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("current_credit")) {
      Object obj = map.get("current_credit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCurrentCredit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCurrentCredit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCurrentCredit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCurrentCredit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCurrentCredit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("year_debit")) {
      Object obj = map.get("year_debit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setYearDebit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setYearDebit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setYearDebit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setYearDebit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setYearDebit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("year_credit")) {
      Object obj = map.get("year_credit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setYearCredit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setYearCredit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setYearCredit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setYearCredit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setYearCredit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("closing_debit")) {
      Object obj = map.get("closing_debit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setClosingDebit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setClosingDebit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setClosingDebit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setClosingDebit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setClosingDebit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("closing_credit")) {
      Object obj = map.get("closing_credit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setClosingCredit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setClosingCredit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setClosingCredit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setClosingCredit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setClosingCredit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_modify_time")) {
      Object obj = map.get("last_modify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLastModifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLastModifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastModifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLastModifyTime(null);
      }
    }
    if(map.containsKey("batch_number")) {
      Object obj = map.get("batch_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_upload")) {
      Object obj = map.get("is_upload");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsUpload((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsUpload(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsUpload(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
