package com.xforceplus.jcchagee.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-09-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AccountDetailLedger implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 属地表ID
   */
  private String tableId;

  /**
   * 组织编码（与“税号”两者必填一个）
   */
  private String orgCode;

  /**
   * 税号（与“组织编码”两者必填一个）
   */
  private String socialCreditCode;

  /**
   * 报表期间年
   */
  private String taxYear;

  /**
   * 报表期间月：01-12季：Q1~Q4年/审计版：13/Y12
   */
  private String taxPeriod;

  /**
   * 参考《报表类型》
   */
  private Long mappingType;

  /**
   * 数据范围：0单体；1合并；21分支机构/分公司；
   */
  private Long label;

  /**
   * 关账=1\n未关账=0
   */
  private Long isCloseAacount;

  /**
   * 0-追加、1-覆盖
   */
  private Long isCover;

  /**
   * 科目编码
   */
  private String accountCode;

  /**
   * 科目名称
   */
  private String accountName;

  /**
   * 账簿
   */
  private String ledger;

  /**
   * 凭证字
   */
  private String voucherType;

  /**
   * 凭证号
   */
  private String voucherNumber;

  /**
   * 摘要
   */
  private String summary;

  /**
   * 借方金额
   */
  private BigDecimal debitAmount;

  /**
   * 贷方金额
   */
  private BigDecimal creditAmount;

  /**
   * 方向
   */
  private String direction;

  /**
   * 余额
   */
  private BigDecimal balance;

  /**
   * 是否结转损益
   */
  private String isCarryForwardProfitLoss;

  /**
   * 数据更新时间戳
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lastModifyTime;

  /**
   * 数据批次
   */
  private String batchNumber;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 日期
   */
  private String postingDate;

  /**
   * 已同步=1\n未同步=0；默认值0
   */
  private Long isUpload;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("table_id", tableId);
      map.put("org_code", orgCode);
      map.put("social_credit_code", socialCreditCode);
      map.put("tax_year", taxYear);
      map.put("tax_period", taxPeriod);
      map.put("mapping_type", mappingType);
      map.put("label", label);
      map.put("is_close_aacount", isCloseAacount);
      map.put("is_cover", isCover);
      map.put("account_code", accountCode);
      map.put("account_name", accountName);
      map.put("ledger", ledger);
      map.put("voucher_type", voucherType);
      map.put("voucher_number", voucherNumber);
      map.put("summary", summary);
      map.put("debit_amount", debitAmount);
      map.put("credit_amount", creditAmount);
      map.put("direction", direction);
      map.put("balance", balance);
      map.put("is_carry_forward_profit_loss", isCarryForwardProfitLoss);
      map.put("last_modify_time", BocpGenUtils.toTimestamp(lastModifyTime));
      map.put("batch_number", batchNumber);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("posting_date", postingDate);
      map.put("is_upload", isUpload);

      return map;
  }

  public static AccountDetailLedger fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    AccountDetailLedger entity = new AccountDetailLedger();
    if(map.containsKey("table_id")) {
      Object obj = map.get("table_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTableId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("social_credit_code")) {
      Object obj = map.get("social_credit_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSocialCreditCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_year")) {
      Object obj = map.get("tax_year");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_period")) {
      Object obj = map.get("tax_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mapping_type")) {
      Object obj = map.get("mapping_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMappingType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMappingType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMappingType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("label")) {
      Object obj = map.get("label");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLabel((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLabel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLabel(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_close_aacount")) {
      Object obj = map.get("is_close_aacount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsCloseAacount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsCloseAacount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsCloseAacount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_cover")) {
      Object obj = map.get("is_cover");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsCover((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsCover(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsCover(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("account_code")) {
      Object obj = map.get("account_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_name")) {
      Object obj = map.get("account_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ledger")) {
      Object obj = map.get("ledger");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLedger((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucher_type")) {
      Object obj = map.get("voucher_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVoucherType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voucher_number")) {
      Object obj = map.get("voucher_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVoucherNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("summary")) {
      Object obj = map.get("summary");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSummary((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("debit_amount")) {
      Object obj = map.get("debit_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDebitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDebitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDebitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDebitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDebitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("credit_amount")) {
      Object obj = map.get("credit_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCreditAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCreditAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCreditAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreditAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreditAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDirection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("balance")) {
      Object obj = map.get("balance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBalance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBalance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBalance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBalance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBalance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("is_carry_forward_profit_loss")) {
      Object obj = map.get("is_carry_forward_profit_loss");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsCarryForwardProfitLoss((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("last_modify_time")) {
      Object obj = map.get("last_modify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLastModifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLastModifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastModifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLastModifyTime(null);
      }
    }
    if(map.containsKey("batch_number")) {
      Object obj = map.get("batch_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("posting_date")) {
      Object obj = map.get("posting_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostingDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_upload")) {
      Object obj = map.get("is_upload");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsUpload((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsUpload(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsUpload(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("table_id")) {
      Object obj = map.get("table_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTableId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("social_credit_code")) {
      Object obj = map.get("social_credit_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSocialCreditCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_year")) {
      Object obj = map.get("tax_year");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxYear((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_period")) {
      Object obj = map.get("tax_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mapping_type")) {
      Object obj = map.get("mapping_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMappingType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMappingType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMappingType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("label")) {
      Object obj = map.get("label");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLabel((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLabel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLabel(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("is_close_aacount")) {
      Object obj = map.get("is_close_aacount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsCloseAacount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsCloseAacount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsCloseAacount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("is_cover")) {
      Object obj = map.get("is_cover");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsCover((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsCover(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsCover(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("account_code")) {
      Object obj = map.get("account_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_name")) {
      Object obj = map.get("account_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ledger")) {
      Object obj = map.get("ledger");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLedger((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("voucher_type")) {
      Object obj = map.get("voucher_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVoucherType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("voucher_number")) {
      Object obj = map.get("voucher_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVoucherNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("summary")) {
      Object obj = map.get("summary");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSummary((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("debit_amount")) {
      Object obj = map.get("debit_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDebitAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDebitAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDebitAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDebitAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDebitAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("credit_amount")) {
      Object obj = map.get("credit_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCreditAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCreditAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCreditAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreditAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreditAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("direction")) {
      Object obj = map.get("direction");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDirection((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("balance")) {
      Object obj = map.get("balance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBalance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBalance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBalance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBalance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBalance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("is_carry_forward_profit_loss")) {
      Object obj = map.get("is_carry_forward_profit_loss");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsCarryForwardProfitLoss((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("last_modify_time")) {
      Object obj = map.get("last_modify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLastModifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLastModifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastModifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLastModifyTime(null);
      }
    }
    if(map.containsKey("batch_number")) {
      Object obj = map.get("batch_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("posting_date")) {
      Object obj = map.get("posting_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPostingDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_upload")) {
      Object obj = map.get("is_upload");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsUpload((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsUpload(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsUpload(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
  }
}
