package com.xforceplus.jcchagee.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-09-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MdmStore implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 主数据ID
   */
  @TableField("mdId")
  private Long mdId;

  /**
   * 主数据编码
   */
  @TableField("mdCode")
  private String mdCode;

  /**
   * 主数据描述
   */
  @TableField("mdDescription")
  private String mdDescription;

  /**
   * 主数据分类
   */
  @TableField("categoryCode")
  private String categoryCode;

  /**
   * 主数据状态
   */
  @TableField("mdStatusCode")
  private String mdStatusCode;

  /**
   * 版本号
   */
  @TableField("mdVersion")
  private Long mdVersion;

  /**
   * 抖音门店ID
   */
  @TableField("douyinId")
  private String douyinId;

  /**
   * 饿了么门店ID
   */
  @TableField("elemeId")
  private String elemeId;

  /**
   * 美团外卖门店ID
   */
  @TableField("meituanTakeawayId")
  private String meituanTakeawayId;

  /**
   * 新美大门店ID
   */
  @TableField("xmdId")
  private String xmdId;

  /**
   * 门店经营类型
   */
  @TableField("storeBusinessType")
  private String storeBusinessType;

  /**
   * 门店经营类型_描述
   */
  @TableField("storeBusinessTypeDesc")
  private String storeBusinessTypeDesc;

  /**
   * 营业执照附件
   */
  @TableField("bizLicense")
  private String bizLicense;

  /**
   * 营业期限
   */
  @TableField("bizTerm")
  private String bizTerm;

  /**
   * 经营范围
   */
  @TableField("businessScope")
  private String businessScope;

  /**
   * 注册地址/经营场所
   */
  @TableField("regAddress")
  private String regAddress;

  /**
   * 法定代表人
   */
  @TableField("legalRepresentative")
  private String legalRepresentative;

  /**
   * 统一社会信用代码
   */
  @TableField("unifiedSocialCode")
  private String unifiedSocialCode;

  /**
   * 营业执照注册名称
   */
  @TableField("bizLicenseName")
  private String bizLicenseName;

  /**
   * 闭店类型
   */
  @TableField("storeClosureType")
  private String storeClosureType;

  /**
   * 闭店类型_描述
   */
  @TableField("storeClosureTypeDesc")
  private String storeClosureTypeDesc;

  /**
   * 是否内部店
   */
  @TableField("isIndoorStore")
  private String isIndoorStore;

  /**
   * 是否内部店_描述
   */
  @TableField("isIndoorStoreDesc")
  private String isIndoorStoreDesc;

  /**
   * 营运教练姓名
   */
  @TableField("opsCoach")
  private String opsCoach;

  /**
   * 营运教练工号
   */
  @TableField("opsCoachCode")
  private String opsCoachCode;

  /**
   * 营运专员姓名
   */
  @TableField("opsSpec")
  private String opsSpec;

  /**
   * 营运专员工号
   */
  @TableField("opsSpecCode")
  private String opsSpecCode;

  /**
   * 所属子公司名称
   */
  @TableField("subOrgName")
  private String subOrgName;

  /**
   * 所属子公司编码
   */
  @TableField("subOrgCode")
  private String subOrgCode;

  /**
   * 门店状态
   */
  @TableField("storeStatus")
  private String storeStatus;

  /**
   * 门店状态_描述
   */
  @TableField("storeStatusDesc")
  private String storeStatusDesc;

  /**
   * 营业结束时间
   */
  @TableField("closingTime")
  private String closingTime;

  /**
   * 营业开始时间
   */
  @TableField("openingTime")
  private String openingTime;

  /**
   * 开业日期
   */
  @TableField("openingDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime openingDate;

  /**
   * 纬度
   */
  private String latitude;

  /**
   * 经度
   */
  private String longitude;

  /**
   * 详细地址
   */
  @TableField("detailAddress")
  private String detailAddress;

  /**
   * 所在区/县
   */
  private String district;

  /**
   * 所在区/县_描述
   */
  @TableField("districtDesc")
  private String districtDesc;

  /**
   * 所在市
   */
  private String city;

  /**
   * 所在市_描述
   */
  @TableField("cityDesc")
  private String cityDesc;

  /**
   * 所在省
   */
  private String province;

  /**
   * 所在省_描述
   */
  @TableField("provinceDesc")
  private String provinceDesc;

  /**
   * 国家/地区
   */
  @TableField("countryRegion")
  private String countryRegion;

  /**
   * 国家/地区_描述
   */
  @TableField("countryRegionDesc")
  private String countryRegionDesc;

  /**
   * 所属加盟商编码
   */
  @TableField("fraCode")
  private String fraCode;

  /**
   * 门店类型
   */
  @TableField("storeType")
  private String storeType;

  /**
   * 门店类型_描述
   */
  @TableField("storeTypeDesc")
  private String storeTypeDesc;

  /**
   * 门店主体性质
   */
  @TableField("storeEntityType")
  private String storeEntityType;

  /**
   * 门店主体性质_描述
   */
  @TableField("storeEntityTypeDesc")
  private String storeEntityTypeDesc;

  /**
   * 旧门店编码
   */
  @TableField("oldStoreNum")
  private String oldStoreNum;

  /**
   * 门店编码
   */
  @TableField("storeCode")
  private String storeCode;

  /**
   * 门店名称
   */
  @TableField("storeName")
  private String storeName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("mdId", mdId);
      map.put("mdCode", mdCode);
      map.put("mdDescription", mdDescription);
      map.put("categoryCode", categoryCode);
      map.put("mdStatusCode", mdStatusCode);
      map.put("mdVersion", mdVersion);
      map.put("douyinId", douyinId);
      map.put("elemeId", elemeId);
      map.put("meituanTakeawayId", meituanTakeawayId);
      map.put("xmdId", xmdId);
      map.put("storeBusinessType", storeBusinessType);
      map.put("storeBusinessTypeDesc", storeBusinessTypeDesc);
      map.put("bizLicense", bizLicense);
      map.put("bizTerm", bizTerm);
      map.put("businessScope", businessScope);
      map.put("regAddress", regAddress);
      map.put("legalRepresentative", legalRepresentative);
      map.put("unifiedSocialCode", unifiedSocialCode);
      map.put("bizLicenseName", bizLicenseName);
      map.put("storeClosureType", storeClosureType);
      map.put("storeClosureTypeDesc", storeClosureTypeDesc);
      map.put("isIndoorStore", isIndoorStore);
      map.put("isIndoorStoreDesc", isIndoorStoreDesc);
      map.put("opsCoach", opsCoach);
      map.put("opsCoachCode", opsCoachCode);
      map.put("opsSpec", opsSpec);
      map.put("opsSpecCode", opsSpecCode);
      map.put("subOrgName", subOrgName);
      map.put("subOrgCode", subOrgCode);
      map.put("storeStatus", storeStatus);
      map.put("storeStatusDesc", storeStatusDesc);
      map.put("closingTime", closingTime);
      map.put("openingTime", openingTime);
      map.put("openingDate", BocpGenUtils.toTimestamp(openingDate));
      map.put("latitude", latitude);
      map.put("longitude", longitude);
      map.put("detailAddress", detailAddress);
      map.put("district", district);
      map.put("districtDesc", districtDesc);
      map.put("city", city);
      map.put("cityDesc", cityDesc);
      map.put("province", province);
      map.put("provinceDesc", provinceDesc);
      map.put("countryRegion", countryRegion);
      map.put("countryRegionDesc", countryRegionDesc);
      map.put("fraCode", fraCode);
      map.put("storeType", storeType);
      map.put("storeTypeDesc", storeTypeDesc);
      map.put("storeEntityType", storeEntityType);
      map.put("storeEntityTypeDesc", storeEntityTypeDesc);
      map.put("oldStoreNum", oldStoreNum);
      map.put("storeCode", storeCode);
      map.put("storeName", storeName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static MdmStore fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MdmStore entity = new MdmStore();
    if(map.containsKey("mdId")) {
      Object obj = map.get("mdId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMdId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("mdCode")) {
      Object obj = map.get("mdCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMdCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdDescription")) {
      Object obj = map.get("mdDescription");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMdDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdStatusCode")) {
      Object obj = map.get("mdStatusCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMdStatusCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mdVersion")) {
      Object obj = map.get("mdVersion");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMdVersion((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMdVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMdVersion(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("douyinId")) {
      Object obj = map.get("douyinId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDouyinId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("elemeId")) {
      Object obj = map.get("elemeId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setElemeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("meituanTakeawayId")) {
      Object obj = map.get("meituanTakeawayId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMeituanTakeawayId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xmdId")) {
      Object obj = map.get("xmdId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXmdId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeBusinessType")) {
      Object obj = map.get("storeBusinessType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeBusinessTypeDesc")) {
      Object obj = map.get("storeBusinessTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreBusinessTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizLicense")) {
      Object obj = map.get("bizLicense");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizLicense((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizTerm")) {
      Object obj = map.get("bizTerm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizTerm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessScope")) {
      Object obj = map.get("businessScope");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessScope((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regAddress")) {
      Object obj = map.get("regAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("legalRepresentative")) {
      Object obj = map.get("legalRepresentative");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLegalRepresentative((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unifiedSocialCode")) {
      Object obj = map.get("unifiedSocialCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnifiedSocialCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bizLicenseName")) {
      Object obj = map.get("bizLicenseName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizLicenseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeClosureType")) {
      Object obj = map.get("storeClosureType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreClosureType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeClosureTypeDesc")) {
      Object obj = map.get("storeClosureTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreClosureTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isIndoorStore")) {
      Object obj = map.get("isIndoorStore");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsIndoorStore((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isIndoorStoreDesc")) {
      Object obj = map.get("isIndoorStoreDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsIndoorStoreDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opsCoach")) {
      Object obj = map.get("opsCoach");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpsCoach((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opsCoachCode")) {
      Object obj = map.get("opsCoachCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpsCoachCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opsSpec")) {
      Object obj = map.get("opsSpec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpsSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("opsSpecCode")) {
      Object obj = map.get("opsSpecCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpsSpecCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subOrgName")) {
      Object obj = map.get("subOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subOrgCode")) {
      Object obj = map.get("subOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeStatus")) {
      Object obj = map.get("storeStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeStatusDesc")) {
      Object obj = map.get("storeStatusDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreStatusDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("closingTime")) {
      Object obj = map.get("closingTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setClosingTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openingTime")) {
      Object obj = map.get("openingTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpeningTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openingDate")) {
      Object obj = map.get("openingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOpeningDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOpeningDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOpeningDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOpeningDate(null);
      }
    }
    if(map.containsKey("latitude")) {
      Object obj = map.get("latitude");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLatitude((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("longitude")) {
      Object obj = map.get("longitude");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLongitude((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detailAddress")) {
      Object obj = map.get("detailAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDetailAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("district")) {
      Object obj = map.get("district");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistrict((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("districtDesc")) {
      Object obj = map.get("districtDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistrictDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cityDesc")) {
      Object obj = map.get("cityDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCityDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("provinceDesc")) {
      Object obj = map.get("provinceDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProvinceDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("countryRegion")) {
      Object obj = map.get("countryRegion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountryRegion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("countryRegionDesc")) {
      Object obj = map.get("countryRegionDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountryRegionDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fraCode")) {
      Object obj = map.get("fraCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFraCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeType")) {
      Object obj = map.get("storeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeTypeDesc")) {
      Object obj = map.get("storeTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeEntityType")) {
      Object obj = map.get("storeEntityType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreEntityType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeEntityTypeDesc")) {
      Object obj = map.get("storeEntityTypeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreEntityTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oldStoreNum")) {
      Object obj = map.get("oldStoreNum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOldStoreNum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeCode")) {
      Object obj = map.get("storeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("mdId")) {
      Object obj = map.get("mdId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMdId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("mdCode")) {
      Object obj = map.get("mdCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMdCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mdDescription")) {
      Object obj = map.get("mdDescription");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMdDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mdStatusCode")) {
      Object obj = map.get("mdStatusCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMdStatusCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mdVersion")) {
      Object obj = map.get("mdVersion");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMdVersion((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMdVersion(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMdVersion(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("douyinId")) {
      Object obj = map.get("douyinId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDouyinId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("elemeId")) {
      Object obj = map.get("elemeId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setElemeId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("meituanTakeawayId")) {
      Object obj = map.get("meituanTakeawayId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMeituanTakeawayId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("xmdId")) {
      Object obj = map.get("xmdId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setXmdId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeBusinessType")) {
      Object obj = map.get("storeBusinessType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeBusinessTypeDesc")) {
      Object obj = map.get("storeBusinessTypeDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreBusinessTypeDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bizLicense")) {
      Object obj = map.get("bizLicense");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizLicense((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bizTerm")) {
      Object obj = map.get("bizTerm");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizTerm((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessScope")) {
      Object obj = map.get("businessScope");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessScope((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regAddress")) {
      Object obj = map.get("regAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("legalRepresentative")) {
      Object obj = map.get("legalRepresentative");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLegalRepresentative((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unifiedSocialCode")) {
      Object obj = map.get("unifiedSocialCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnifiedSocialCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bizLicenseName")) {
      Object obj = map.get("bizLicenseName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizLicenseName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeClosureType")) {
      Object obj = map.get("storeClosureType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreClosureType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeClosureTypeDesc")) {
      Object obj = map.get("storeClosureTypeDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreClosureTypeDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isIndoorStore")) {
      Object obj = map.get("isIndoorStore");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsIndoorStore((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isIndoorStoreDesc")) {
      Object obj = map.get("isIndoorStoreDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsIndoorStoreDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("opsCoach")) {
      Object obj = map.get("opsCoach");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOpsCoach((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("opsCoachCode")) {
      Object obj = map.get("opsCoachCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOpsCoachCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("opsSpec")) {
      Object obj = map.get("opsSpec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOpsSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("opsSpecCode")) {
      Object obj = map.get("opsSpecCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOpsSpecCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("subOrgName")) {
      Object obj = map.get("subOrgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSubOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("subOrgCode")) {
      Object obj = map.get("subOrgCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSubOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeStatus")) {
      Object obj = map.get("storeStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeStatusDesc")) {
      Object obj = map.get("storeStatusDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreStatusDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("closingTime")) {
      Object obj = map.get("closingTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setClosingTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("openingTime")) {
      Object obj = map.get("openingTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOpeningTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("openingDate")) {
      Object obj = map.get("openingDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOpeningDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOpeningDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOpeningDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOpeningDate(null);
      }
    }
    if(map.containsKey("latitude")) {
      Object obj = map.get("latitude");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLatitude((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("longitude")) {
      Object obj = map.get("longitude");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLongitude((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("detailAddress")) {
      Object obj = map.get("detailAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDetailAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("district")) {
      Object obj = map.get("district");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistrict((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("districtDesc")) {
      Object obj = map.get("districtDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistrictDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cityDesc")) {
      Object obj = map.get("cityDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCityDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProvince((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("provinceDesc")) {
      Object obj = map.get("provinceDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProvinceDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("countryRegion")) {
      Object obj = map.get("countryRegion");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCountryRegion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("countryRegionDesc")) {
      Object obj = map.get("countryRegionDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCountryRegionDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fraCode")) {
      Object obj = map.get("fraCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFraCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeType")) {
      Object obj = map.get("storeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeTypeDesc")) {
      Object obj = map.get("storeTypeDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreTypeDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeEntityType")) {
      Object obj = map.get("storeEntityType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreEntityType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeEntityTypeDesc")) {
      Object obj = map.get("storeEntityTypeDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreEntityTypeDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oldStoreNum")) {
      Object obj = map.get("oldStoreNum");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOldStoreNum((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeCode")) {
      Object obj = map.get("storeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
