package com.xforceplus.jcchagee.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-09-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OwnerEquityStatement implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 属地表id
   */
  private String tableId;

  /**
   * 组织编码（与“税号”两者必填一个）
   */
  private String orgCode;

  /**
   * 税号（与“组织编码”两者必填一个）
   */
  private String socialCreditCode;

  /**
   * 报表期间年
   */
  private String taxYear;

  /**
   * 报表期间月：01-12季：Q1~Q4年/审计版：13/Y12
   */
  private String taxPeriod;

  /**
   * 参考《报表类型》
   */
  private Long mappingType;

  /**
   * 数据范围：0单体； 1总分合并；19集团合并；
   */
  private Long label;

  /**
   * 关账=1\n未关账=0
   */
  private String isCloseAacount;

  /**
   * 项目名称（此处可能不适用，因为通常所有者权益表不细分到项目）
   */
  private String reportProject;

  /**
   * 本年金额-实收资本（或股本）
   */
  private BigDecimal thisPaidCapital;

  /**
   * 本年金额-其他权益工具-优先股
   */
  private BigDecimal thisPreferredStock;

  /**
   * 本年金额-其他权益工具-永续债
   */
  private BigDecimal thisPerpetualDebt;

  /**
   * 本年金额-其他权益工具-其他
   */
  private BigDecimal thisOther;

  /**
   * 本年金额-资本公积
   */
  private BigDecimal thisCapitalReserve;

  /**
   * 本年金额-减：库存股
   */
  private BigDecimal thisTreasuryStock;

  /**
   * 本年金额-专项储备
   */
  private BigDecimal thisSpecialReserve;

  /**
   * 本期金额_其他综合收益
   */
  private BigDecimal thisOtherComprehensiveIncome;

  /**
   * 本期金额_盈余公积
   */
  private BigDecimal thisSurplusReserve;

  /**
   * 本年金额-未分配利润
   */
  private BigDecimal thisUndistributedProfit;

  /**
   * 本年金额-所有者权益合计
   */
  private BigDecimal thisOwnerEquity;

  /**
   * 上年金额-实收资本（或股本）
   */
  private BigDecimal lastPaidCapital;

  /**
   * 上年金额-其他权益工具-优先股
   */
  private BigDecimal lastPreferredStock;

  /**
   * 上年金额-其他权益工具-永续债
   */
  private BigDecimal lastPerpetualDebt;

  /**
   * 上年金额-其他权益工具-其他
   */
  private BigDecimal lastOther;

  /**
   * 上年金额-资本公积
   */
  private BigDecimal lastCapitalReserve;

  /**
   * 上年金额-减：库存股
   */
  private BigDecimal lastTreasuryStock;

  /**
   * 上年金额-专项储备
   */
  private BigDecimal lastSpecialReserve;

  /**
   * 上年金额_其他综合收益
   */
  private BigDecimal lastOtherComprehensiveIncome;

  /**
   * 上年金额_盈余公积
   */
  private BigDecimal lastSurplusReserve;

  /**
   * 上年金额-未分配利润
   */
  private BigDecimal lastUndistributedProfit;

  /**
   * 上年金额-所有者权益合计
   */
  private BigDecimal lastOwnerEquity;

  /**
   * 数据更新时间戳
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lastModifyTime;

  /**
   * 数据批次
   */
  private String batchNumber;

  /**
   * 已同步=1\n未同步=0；默认值0
   */
  private Long isUpload;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("table_id", tableId);
      map.put("org_code", orgCode);
      map.put("social_credit_code", socialCreditCode);
      map.put("tax_year", taxYear);
      map.put("tax_period", taxPeriod);
      map.put("mapping_type", mappingType);
      map.put("label", label);
      map.put("is_close_aacount", isCloseAacount);
      map.put("report_project", reportProject);
      map.put("this_paid_capital", thisPaidCapital);
      map.put("this_preferred_stock", thisPreferredStock);
      map.put("this_perpetual_debt", thisPerpetualDebt);
      map.put("this_other", thisOther);
      map.put("this_capital_reserve", thisCapitalReserve);
      map.put("this_treasury_stock", thisTreasuryStock);
      map.put("this_special_reserve", thisSpecialReserve);
      map.put("this_other_comprehensive_income", thisOtherComprehensiveIncome);
      map.put("this_surplus_reserve", thisSurplusReserve);
      map.put("this_undistributed_profit", thisUndistributedProfit);
      map.put("this_owner_equity", thisOwnerEquity);
      map.put("last_paid_capital", lastPaidCapital);
      map.put("last_preferred_stock", lastPreferredStock);
      map.put("last_perpetual_debt", lastPerpetualDebt);
      map.put("last_other", lastOther);
      map.put("last_capital_reserve", lastCapitalReserve);
      map.put("last_treasury_stock", lastTreasuryStock);
      map.put("last_special_reserve", lastSpecialReserve);
      map.put("last_other_comprehensive_income", lastOtherComprehensiveIncome);
      map.put("last_surplus_reserve", lastSurplusReserve);
      map.put("last_undistributed_profit", lastUndistributedProfit);
      map.put("last_owner_equity", lastOwnerEquity);
      map.put("last_modify_time", BocpGenUtils.toTimestamp(lastModifyTime));
      map.put("batch_number", batchNumber);
      map.put("is_upload", isUpload);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static OwnerEquityStatement fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OwnerEquityStatement entity = new OwnerEquityStatement();
    if(map.containsKey("table_id")) {
      Object obj = map.get("table_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTableId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("social_credit_code")) {
      Object obj = map.get("social_credit_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSocialCreditCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_year")) {
      Object obj = map.get("tax_year");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_period")) {
      Object obj = map.get("tax_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mapping_type")) {
      Object obj = map.get("mapping_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMappingType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMappingType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMappingType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("label")) {
      Object obj = map.get("label");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLabel((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLabel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLabel(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_close_aacount")) {
      Object obj = map.get("is_close_aacount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsCloseAacount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("report_project")) {
      Object obj = map.get("report_project");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReportProject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("this_paid_capital")) {
      Object obj = map.get("this_paid_capital");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setThisPaidCapital((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setThisPaidCapital(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setThisPaidCapital(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThisPaidCapital(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThisPaidCapital(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("this_preferred_stock")) {
      Object obj = map.get("this_preferred_stock");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setThisPreferredStock((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setThisPreferredStock(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setThisPreferredStock(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThisPreferredStock(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThisPreferredStock(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("this_perpetual_debt")) {
      Object obj = map.get("this_perpetual_debt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setThisPerpetualDebt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setThisPerpetualDebt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setThisPerpetualDebt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThisPerpetualDebt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThisPerpetualDebt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("this_other")) {
      Object obj = map.get("this_other");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setThisOther((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setThisOther(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setThisOther(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThisOther(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThisOther(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("this_capital_reserve")) {
      Object obj = map.get("this_capital_reserve");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setThisCapitalReserve((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setThisCapitalReserve(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setThisCapitalReserve(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThisCapitalReserve(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThisCapitalReserve(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("this_treasury_stock")) {
      Object obj = map.get("this_treasury_stock");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setThisTreasuryStock((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setThisTreasuryStock(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setThisTreasuryStock(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThisTreasuryStock(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThisTreasuryStock(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("this_special_reserve")) {
      Object obj = map.get("this_special_reserve");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setThisSpecialReserve((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setThisSpecialReserve(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setThisSpecialReserve(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThisSpecialReserve(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThisSpecialReserve(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("this_other_comprehensive_income")) {
      Object obj = map.get("this_other_comprehensive_income");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setThisOtherComprehensiveIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setThisOtherComprehensiveIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setThisOtherComprehensiveIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThisOtherComprehensiveIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThisOtherComprehensiveIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("this_surplus_reserve")) {
      Object obj = map.get("this_surplus_reserve");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setThisSurplusReserve((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setThisSurplusReserve(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setThisSurplusReserve(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThisSurplusReserve(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThisSurplusReserve(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("this_undistributed_profit")) {
      Object obj = map.get("this_undistributed_profit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setThisUndistributedProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setThisUndistributedProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setThisUndistributedProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThisUndistributedProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThisUndistributedProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("this_owner_equity")) {
      Object obj = map.get("this_owner_equity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setThisOwnerEquity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setThisOwnerEquity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setThisOwnerEquity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setThisOwnerEquity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setThisOwnerEquity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_paid_capital")) {
      Object obj = map.get("last_paid_capital");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLastPaidCapital((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLastPaidCapital(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLastPaidCapital(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastPaidCapital(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLastPaidCapital(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_preferred_stock")) {
      Object obj = map.get("last_preferred_stock");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLastPreferredStock((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLastPreferredStock(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLastPreferredStock(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastPreferredStock(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLastPreferredStock(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_perpetual_debt")) {
      Object obj = map.get("last_perpetual_debt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLastPerpetualDebt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLastPerpetualDebt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLastPerpetualDebt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastPerpetualDebt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLastPerpetualDebt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_other")) {
      Object obj = map.get("last_other");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLastOther((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLastOther(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLastOther(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastOther(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLastOther(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_capital_reserve")) {
      Object obj = map.get("last_capital_reserve");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLastCapitalReserve((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLastCapitalReserve(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLastCapitalReserve(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastCapitalReserve(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLastCapitalReserve(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_treasury_stock")) {
      Object obj = map.get("last_treasury_stock");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLastTreasuryStock((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLastTreasuryStock(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLastTreasuryStock(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastTreasuryStock(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLastTreasuryStock(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_special_reserve")) {
      Object obj = map.get("last_special_reserve");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLastSpecialReserve((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLastSpecialReserve(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLastSpecialReserve(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastSpecialReserve(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLastSpecialReserve(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_other_comprehensive_income")) {
      Object obj = map.get("last_other_comprehensive_income");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLastOtherComprehensiveIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLastOtherComprehensiveIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLastOtherComprehensiveIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastOtherComprehensiveIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLastOtherComprehensiveIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_surplus_reserve")) {
      Object obj = map.get("last_surplus_reserve");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLastSurplusReserve((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLastSurplusReserve(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLastSurplusReserve(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastSurplusReserve(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLastSurplusReserve(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_undistributed_profit")) {
      Object obj = map.get("last_undistributed_profit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLastUndistributedProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLastUndistributedProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLastUndistributedProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastUndistributedProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLastUndistributedProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_owner_equity")) {
      Object obj = map.get("last_owner_equity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLastOwnerEquity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLastOwnerEquity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLastOwnerEquity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastOwnerEquity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLastOwnerEquity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_modify_time")) {
      Object obj = map.get("last_modify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLastModifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLastModifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastModifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLastModifyTime(null);
      }
    }
    if(map.containsKey("batch_number")) {
      Object obj = map.get("batch_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_upload")) {
      Object obj = map.get("is_upload");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsUpload((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsUpload(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsUpload(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("table_id")) {
      Object obj = map.get("table_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTableId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("social_credit_code")) {
      Object obj = map.get("social_credit_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSocialCreditCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_year")) {
      Object obj = map.get("tax_year");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxYear((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_period")) {
      Object obj = map.get("tax_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mapping_type")) {
      Object obj = map.get("mapping_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMappingType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMappingType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMappingType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("label")) {
      Object obj = map.get("label");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLabel((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLabel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLabel(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("is_close_aacount")) {
      Object obj = map.get("is_close_aacount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsCloseAacount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("report_project")) {
      Object obj = map.get("report_project");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReportProject((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("this_paid_capital")) {
      Object obj = map.get("this_paid_capital");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setThisPaidCapital((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setThisPaidCapital(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setThisPaidCapital(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThisPaidCapital(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setThisPaidCapital(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("this_preferred_stock")) {
      Object obj = map.get("this_preferred_stock");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setThisPreferredStock((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setThisPreferredStock(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setThisPreferredStock(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThisPreferredStock(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setThisPreferredStock(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("this_perpetual_debt")) {
      Object obj = map.get("this_perpetual_debt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setThisPerpetualDebt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setThisPerpetualDebt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setThisPerpetualDebt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThisPerpetualDebt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setThisPerpetualDebt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("this_other")) {
      Object obj = map.get("this_other");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setThisOther((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setThisOther(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setThisOther(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThisOther(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setThisOther(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("this_capital_reserve")) {
      Object obj = map.get("this_capital_reserve");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setThisCapitalReserve((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setThisCapitalReserve(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setThisCapitalReserve(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThisCapitalReserve(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setThisCapitalReserve(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("this_treasury_stock")) {
      Object obj = map.get("this_treasury_stock");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setThisTreasuryStock((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setThisTreasuryStock(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setThisTreasuryStock(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThisTreasuryStock(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setThisTreasuryStock(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("this_special_reserve")) {
      Object obj = map.get("this_special_reserve");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setThisSpecialReserve((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setThisSpecialReserve(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setThisSpecialReserve(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThisSpecialReserve(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setThisSpecialReserve(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("this_other_comprehensive_income")) {
      Object obj = map.get("this_other_comprehensive_income");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setThisOtherComprehensiveIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setThisOtherComprehensiveIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setThisOtherComprehensiveIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThisOtherComprehensiveIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setThisOtherComprehensiveIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("this_surplus_reserve")) {
      Object obj = map.get("this_surplus_reserve");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setThisSurplusReserve((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setThisSurplusReserve(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setThisSurplusReserve(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThisSurplusReserve(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setThisSurplusReserve(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("this_undistributed_profit")) {
      Object obj = map.get("this_undistributed_profit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setThisUndistributedProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setThisUndistributedProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setThisUndistributedProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThisUndistributedProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setThisUndistributedProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("this_owner_equity")) {
      Object obj = map.get("this_owner_equity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setThisOwnerEquity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setThisOwnerEquity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setThisOwnerEquity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setThisOwnerEquity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setThisOwnerEquity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_paid_capital")) {
      Object obj = map.get("last_paid_capital");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLastPaidCapital((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLastPaidCapital(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLastPaidCapital(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastPaidCapital(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLastPaidCapital(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_preferred_stock")) {
      Object obj = map.get("last_preferred_stock");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLastPreferredStock((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLastPreferredStock(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLastPreferredStock(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastPreferredStock(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLastPreferredStock(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_perpetual_debt")) {
      Object obj = map.get("last_perpetual_debt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLastPerpetualDebt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLastPerpetualDebt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLastPerpetualDebt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastPerpetualDebt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLastPerpetualDebt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_other")) {
      Object obj = map.get("last_other");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLastOther((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLastOther(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLastOther(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastOther(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLastOther(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_capital_reserve")) {
      Object obj = map.get("last_capital_reserve");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLastCapitalReserve((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLastCapitalReserve(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLastCapitalReserve(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastCapitalReserve(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLastCapitalReserve(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_treasury_stock")) {
      Object obj = map.get("last_treasury_stock");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLastTreasuryStock((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLastTreasuryStock(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLastTreasuryStock(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastTreasuryStock(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLastTreasuryStock(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_special_reserve")) {
      Object obj = map.get("last_special_reserve");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLastSpecialReserve((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLastSpecialReserve(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLastSpecialReserve(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastSpecialReserve(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLastSpecialReserve(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_other_comprehensive_income")) {
      Object obj = map.get("last_other_comprehensive_income");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLastOtherComprehensiveIncome((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLastOtherComprehensiveIncome(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLastOtherComprehensiveIncome(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastOtherComprehensiveIncome(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLastOtherComprehensiveIncome(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_surplus_reserve")) {
      Object obj = map.get("last_surplus_reserve");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLastSurplusReserve((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLastSurplusReserve(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLastSurplusReserve(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastSurplusReserve(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLastSurplusReserve(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_undistributed_profit")) {
      Object obj = map.get("last_undistributed_profit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLastUndistributedProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLastUndistributedProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLastUndistributedProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastUndistributedProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLastUndistributedProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_owner_equity")) {
      Object obj = map.get("last_owner_equity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLastOwnerEquity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLastOwnerEquity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLastOwnerEquity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastOwnerEquity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLastOwnerEquity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_modify_time")) {
      Object obj = map.get("last_modify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLastModifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLastModifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastModifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLastModifyTime(null);
      }
    }
    if(map.containsKey("batch_number")) {
      Object obj = map.get("batch_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_upload")) {
      Object obj = map.get("is_upload");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsUpload((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsUpload(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsUpload(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
