package com.xforceplus.jcchagee.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-09-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ProfitStatement implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 属地表id
   */
  private String tableId;

  /**
   * 组织编码（与“税号”两者必填一个）
   */
  private String orgCode;

  /**
   * 税号（与“组织编码”两者必填一个）
   */
  private String socialCreditCode;

  /**
   * 报表期间年
   */
  private String taxYear;

  /**
   * 报表期间月：01-12季：Q1~Q4年/审计版：13/Y12
   */
  private String taxPeriod;

  /**
   * 参考《报表类型》
   */
  private Long mappingType;

  /**
   * 数据范围：0单体； 1总分合并；19集团合并；
   */
  private String label;

  /**
   * 关账=1；未关账=0
   */
  private Long isCloseAacount;

  /**
   * 项目名称（或科目名称）
   */
  private String reportProject;

  /**
   * 本期金额，自年初起至报告期末止的累计金额
   */
  private BigDecimal currentAmount;

  /**
   * 上期金额，上年同期累计金额
   */
  private BigDecimal lastAmount;

  /**
   * 数据更新时间戳
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lastModifyTime;

  /**
   * 数据批次
   */
  private String batchNumber;

  /**
   * 已同步=1；未同步=0；默认值0
   */
  private Long isUpload;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("table_id", tableId);
      map.put("org_code", orgCode);
      map.put("social_credit_code", socialCreditCode);
      map.put("tax_year", taxYear);
      map.put("tax_period", taxPeriod);
      map.put("mapping_type", mappingType);
      map.put("label", label);
      map.put("is_close_aacount", isCloseAacount);
      map.put("report_project", reportProject);
      map.put("current_amount", currentAmount);
      map.put("last_amount", lastAmount);
      map.put("last_modify_time", BocpGenUtils.toTimestamp(lastModifyTime));
      map.put("batch_number", batchNumber);
      map.put("is_upload", isUpload);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static ProfitStatement fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ProfitStatement entity = new ProfitStatement();
    if(map.containsKey("table_id")) {
      Object obj = map.get("table_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTableId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("social_credit_code")) {
      Object obj = map.get("social_credit_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSocialCreditCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_year")) {
      Object obj = map.get("tax_year");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_period")) {
      Object obj = map.get("tax_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mapping_type")) {
      Object obj = map.get("mapping_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMappingType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMappingType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMappingType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("label")) {
      Object obj = map.get("label");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLabel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_close_aacount")) {
      Object obj = map.get("is_close_aacount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsCloseAacount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsCloseAacount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsCloseAacount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("report_project")) {
      Object obj = map.get("report_project");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReportProject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("current_amount")) {
      Object obj = map.get("current_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCurrentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_amount")) {
      Object obj = map.get("last_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLastAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLastAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLastAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLastAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("last_modify_time")) {
      Object obj = map.get("last_modify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLastModifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLastModifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastModifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLastModifyTime(null);
      }
    }
    if(map.containsKey("batch_number")) {
      Object obj = map.get("batch_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_upload")) {
      Object obj = map.get("is_upload");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsUpload((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsUpload(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsUpload(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("table_id")) {
      Object obj = map.get("table_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTableId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("social_credit_code")) {
      Object obj = map.get("social_credit_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSocialCreditCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_year")) {
      Object obj = map.get("tax_year");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxYear((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_period")) {
      Object obj = map.get("tax_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mapping_type")) {
      Object obj = map.get("mapping_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMappingType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMappingType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setMappingType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("label")) {
      Object obj = map.get("label");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLabel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_close_aacount")) {
      Object obj = map.get("is_close_aacount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsCloseAacount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsCloseAacount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsCloseAacount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("report_project")) {
      Object obj = map.get("report_project");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReportProject((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("current_amount")) {
      Object obj = map.get("current_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCurrentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCurrentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCurrentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCurrentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCurrentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_amount")) {
      Object obj = map.get("last_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLastAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLastAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLastAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLastAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("last_modify_time")) {
      Object obj = map.get("last_modify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLastModifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLastModifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastModifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLastModifyTime(null);
      }
    }
    if(map.containsKey("batch_number")) {
      Object obj = map.get("batch_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_upload")) {
      Object obj = map.get("is_upload");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsUpload((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsUpload(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsUpload(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
