package com.xforceplus.jcchagee.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcchagee.entity.AccountBalanceTable;
import com.xforceplus.jcchagee.service.IAccountBalanceTableService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-24
 */
@RestController
public class AccountBalanceTableController {

  @Autowired
  private IAccountBalanceTableService accountBalanceTableServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param accountBalanceTable ${table.comment}
   * @return
   */
  @GetMapping("/accountbalancetables" )
  public XfR getAccountBalanceTables(XfPage page, AccountBalanceTable accountBalanceTable) {
    return XfR.ok(accountBalanceTableServiceImpl.page(page, Wrappers.query(accountBalanceTable)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/accountbalancetables/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(accountBalanceTableServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param accountBalanceTable ${table.comment}
   * @return XfR
   */
  @PostMapping("/accountbalancetables")
  public XfR save(@RequestBody AccountBalanceTable accountBalanceTable) {
     return XfR.ok(accountBalanceTableServiceImpl.save(accountBalanceTable));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param accountBalanceTable ${table.comment}
   * @return XfR
   */
  @PutMapping("/accountbalancetables/{id}")
  public XfR putUpdate(@RequestBody AccountBalanceTable accountBalanceTable,@PathVariable Long id) {
      accountBalanceTable.setId(id);
      return XfR.ok(accountBalanceTableServiceImpl.updateById(accountBalanceTable));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param accountBalanceTable ${table.comment}
   * @return XfR
   */
  @PatchMapping("/accountbalancetables/{id}")
  public XfR patchUpdate(@RequestBody AccountBalanceTable accountBalanceTable,@PathVariable Long id) {
      AccountBalanceTable upaccountBalanceTable = accountBalanceTableServiceImpl.getById(id);
      if(upaccountBalanceTable != null){
        upaccountBalanceTable = ObjectCopyUtils.copyProperties(accountBalanceTable,upaccountBalanceTable,true);
      }
      return XfR.ok(accountBalanceTableServiceImpl.updateById(upaccountBalanceTable));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/accountbalancetables/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(accountBalanceTableServiceImpl.removeById(id));
  }

  @PostMapping("/accountbalancetables/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "account_balance_table");
     params.put("request", condition);

     return XfR.ok(accountBalanceTableServiceImpl.querys(params));
  }

}
