package com.xforceplus.jcchagee.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcchagee.entity.AccountDetailLedger;
import com.xforceplus.jcchagee.service.IAccountDetailLedgerService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-24
 */
@RestController
public class AccountDetailLedgerController {

  @Autowired
  private IAccountDetailLedgerService accountDetailLedgerServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param accountDetailLedger ${table.comment}
   * @return
   */
  @GetMapping("/accountdetailledgers" )
  public XfR getAccountDetailLedgers(XfPage page, AccountDetailLedger accountDetailLedger) {
    return XfR.ok(accountDetailLedgerServiceImpl.page(page, Wrappers.query(accountDetailLedger)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/accountdetailledgers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(accountDetailLedgerServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param accountDetailLedger ${table.comment}
   * @return XfR
   */
  @PostMapping("/accountdetailledgers")
  public XfR save(@RequestBody AccountDetailLedger accountDetailLedger) {
     return XfR.ok(accountDetailLedgerServiceImpl.save(accountDetailLedger));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param accountDetailLedger ${table.comment}
   * @return XfR
   */
  @PutMapping("/accountdetailledgers/{id}")
  public XfR putUpdate(@RequestBody AccountDetailLedger accountDetailLedger,@PathVariable Long id) {
      accountDetailLedger.setId(id);
      return XfR.ok(accountDetailLedgerServiceImpl.updateById(accountDetailLedger));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param accountDetailLedger ${table.comment}
   * @return XfR
   */
  @PatchMapping("/accountdetailledgers/{id}")
  public XfR patchUpdate(@RequestBody AccountDetailLedger accountDetailLedger,@PathVariable Long id) {
      AccountDetailLedger upaccountDetailLedger = accountDetailLedgerServiceImpl.getById(id);
      if(upaccountDetailLedger != null){
        upaccountDetailLedger = ObjectCopyUtils.copyProperties(accountDetailLedger,upaccountDetailLedger,true);
      }
      return XfR.ok(accountDetailLedgerServiceImpl.updateById(upaccountDetailLedger));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/accountdetailledgers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(accountDetailLedgerServiceImpl.removeById(id));
  }

  @PostMapping("/accountdetailledgers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "account_detail_ledger");
     params.put("request", condition);

     return XfR.ok(accountDetailLedgerServiceImpl.querys(params));
  }

}
