package com.xforceplus.jcchagee.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcchagee.entity.BalanceSheet;
import com.xforceplus.jcchagee.service.IBalanceSheetService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-24
 */
@RestController
public class BalanceSheetController {

  @Autowired
  private IBalanceSheetService balanceSheetServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param balanceSheet ${table.comment}
   * @return
   */
  @GetMapping("/balancesheets" )
  public XfR getBalanceSheets(XfPage page, BalanceSheet balanceSheet) {
    return XfR.ok(balanceSheetServiceImpl.page(page, Wrappers.query(balanceSheet)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/balancesheets/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(balanceSheetServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param balanceSheet ${table.comment}
   * @return XfR
   */
  @PostMapping("/balancesheets")
  public XfR save(@RequestBody BalanceSheet balanceSheet) {
     return XfR.ok(balanceSheetServiceImpl.save(balanceSheet));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param balanceSheet ${table.comment}
   * @return XfR
   */
  @PutMapping("/balancesheets/{id}")
  public XfR putUpdate(@RequestBody BalanceSheet balanceSheet,@PathVariable Long id) {
      balanceSheet.setId(id);
      return XfR.ok(balanceSheetServiceImpl.updateById(balanceSheet));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param balanceSheet ${table.comment}
   * @return XfR
   */
  @PatchMapping("/balancesheets/{id}")
  public XfR patchUpdate(@RequestBody BalanceSheet balanceSheet,@PathVariable Long id) {
      BalanceSheet upbalanceSheet = balanceSheetServiceImpl.getById(id);
      if(upbalanceSheet != null){
        upbalanceSheet = ObjectCopyUtils.copyProperties(balanceSheet,upbalanceSheet,true);
      }
      return XfR.ok(balanceSheetServiceImpl.updateById(upbalanceSheet));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/balancesheets/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(balanceSheetServiceImpl.removeById(id));
  }

  @PostMapping("/balancesheets/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "balance_sheet");
     params.put("request", condition);

     return XfR.ok(balanceSheetServiceImpl.querys(params));
  }

}
