package com.xforceplus.jcchagee.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcchagee.entity.CashFlowStatement;
import com.xforceplus.jcchagee.service.ICashFlowStatementService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-24
 */
@RestController
public class CashFlowStatementController {

  @Autowired
  private ICashFlowStatementService cashFlowStatementServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cashFlowStatement ${table.comment}
   * @return
   */
  @GetMapping("/cashflowstatements" )
  public XfR getCashFlowStatements(XfPage page, CashFlowStatement cashFlowStatement) {
    return XfR.ok(cashFlowStatementServiceImpl.page(page, Wrappers.query(cashFlowStatement)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/cashflowstatements/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(cashFlowStatementServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param cashFlowStatement ${table.comment}
   * @return XfR
   */
  @PostMapping("/cashflowstatements")
  public XfR save(@RequestBody CashFlowStatement cashFlowStatement) {
     return XfR.ok(cashFlowStatementServiceImpl.save(cashFlowStatement));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param cashFlowStatement ${table.comment}
   * @return XfR
   */
  @PutMapping("/cashflowstatements/{id}")
  public XfR putUpdate(@RequestBody CashFlowStatement cashFlowStatement,@PathVariable Long id) {
      cashFlowStatement.setId(id);
      return XfR.ok(cashFlowStatementServiceImpl.updateById(cashFlowStatement));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param cashFlowStatement ${table.comment}
   * @return XfR
   */
  @PatchMapping("/cashflowstatements/{id}")
  public XfR patchUpdate(@RequestBody CashFlowStatement cashFlowStatement,@PathVariable Long id) {
      CashFlowStatement upcashFlowStatement = cashFlowStatementServiceImpl.getById(id);
      if(upcashFlowStatement != null){
        upcashFlowStatement = ObjectCopyUtils.copyProperties(cashFlowStatement,upcashFlowStatement,true);
      }
      return XfR.ok(cashFlowStatementServiceImpl.updateById(upcashFlowStatement));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/cashflowstatements/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(cashFlowStatementServiceImpl.removeById(id));
  }

  @PostMapping("/cashflowstatements/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "cash_flow_statement");
     params.put("request", condition);

     return XfR.ok(cashFlowStatementServiceImpl.querys(params));
  }

}
