package com.xforceplus.jcchagee.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcchagee.entity.OwnerEquityStatement;
import com.xforceplus.jcchagee.service.IOwnerEquityStatementService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-24
 */
@RestController
public class OwnerEquityStatementController {

  @Autowired
  private IOwnerEquityStatementService ownerEquityStatementServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ownerEquityStatement ${table.comment}
   * @return
   */
  @GetMapping("/ownerequitystatements" )
  public XfR getOwnerEquityStatements(XfPage page, OwnerEquityStatement ownerEquityStatement) {
    return XfR.ok(ownerEquityStatementServiceImpl.page(page, Wrappers.query(ownerEquityStatement)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ownerequitystatements/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ownerEquityStatementServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ownerEquityStatement ${table.comment}
   * @return XfR
   */
  @PostMapping("/ownerequitystatements")
  public XfR save(@RequestBody OwnerEquityStatement ownerEquityStatement) {
     return XfR.ok(ownerEquityStatementServiceImpl.save(ownerEquityStatement));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ownerEquityStatement ${table.comment}
   * @return XfR
   */
  @PutMapping("/ownerequitystatements/{id}")
  public XfR putUpdate(@RequestBody OwnerEquityStatement ownerEquityStatement,@PathVariable Long id) {
      ownerEquityStatement.setId(id);
      return XfR.ok(ownerEquityStatementServiceImpl.updateById(ownerEquityStatement));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ownerEquityStatement ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ownerequitystatements/{id}")
  public XfR patchUpdate(@RequestBody OwnerEquityStatement ownerEquityStatement,@PathVariable Long id) {
      OwnerEquityStatement upownerEquityStatement = ownerEquityStatementServiceImpl.getById(id);
      if(upownerEquityStatement != null){
        upownerEquityStatement = ObjectCopyUtils.copyProperties(ownerEquityStatement,upownerEquityStatement,true);
      }
      return XfR.ok(ownerEquityStatementServiceImpl.updateById(upownerEquityStatement));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ownerequitystatements/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ownerEquityStatementServiceImpl.removeById(id));
  }

  @PostMapping("/ownerequitystatements/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "owner_equity_statement");
     params.put("request", condition);

     return XfR.ok(ownerEquityStatementServiceImpl.querys(params));
  }

}
