package com.xforceplus.jcchagee.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcchagee.entity.ProfitStatement;
import com.xforceplus.jcchagee.service.IProfitStatementService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-24
 */
@RestController
public class ProfitStatementController {

  @Autowired
  private IProfitStatementService profitStatementServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param profitStatement ${table.comment}
   * @return
   */
  @GetMapping("/profitstatements" )
  public XfR getProfitStatements(XfPage page, ProfitStatement profitStatement) {
    return XfR.ok(profitStatementServiceImpl.page(page, Wrappers.query(profitStatement)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/profitstatements/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(profitStatementServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param profitStatement ${table.comment}
   * @return XfR
   */
  @PostMapping("/profitstatements")
  public XfR save(@RequestBody ProfitStatement profitStatement) {
     return XfR.ok(profitStatementServiceImpl.save(profitStatement));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param profitStatement ${table.comment}
   * @return XfR
   */
  @PutMapping("/profitstatements/{id}")
  public XfR putUpdate(@RequestBody ProfitStatement profitStatement,@PathVariable Long id) {
      profitStatement.setId(id);
      return XfR.ok(profitStatementServiceImpl.updateById(profitStatement));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param profitStatement ${table.comment}
   * @return XfR
   */
  @PatchMapping("/profitstatements/{id}")
  public XfR patchUpdate(@RequestBody ProfitStatement profitStatement,@PathVariable Long id) {
      ProfitStatement upprofitStatement = profitStatementServiceImpl.getById(id);
      if(upprofitStatement != null){
        upprofitStatement = ObjectCopyUtils.copyProperties(profitStatement,upprofitStatement,true);
      }
      return XfR.ok(profitStatementServiceImpl.updateById(upprofitStatement));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/profitstatements/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(profitStatementServiceImpl.removeById(id));
  }

  @PostMapping("/profitstatements/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "profit_statement");
     params.put("request", condition);

     return XfR.ok(profitStatementServiceImpl.querys(params));
  }

}
