package com.xforceplus.jcchagee.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcchagee.entity.TaxConfig;
import com.xforceplus.jcchagee.service.ITaxConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-09-24
 */
@RestController
public class TaxConfigController {

  @Autowired
  private ITaxConfigService taxConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxConfig ${table.comment}
   * @return
   */
  @GetMapping("/taxconfigs" )
  public XfR getTaxConfigs(XfPage page, TaxConfig taxConfig) {
    return XfR.ok(taxConfigServiceImpl.page(page, Wrappers.query(taxConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxconfigs")
  public XfR save(@RequestBody TaxConfig taxConfig) {
     return XfR.ok(taxConfigServiceImpl.save(taxConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxconfigs/{id}")
  public XfR putUpdate(@RequestBody TaxConfig taxConfig,@PathVariable Long id) {
      taxConfig.setId(id);
      return XfR.ok(taxConfigServiceImpl.updateById(taxConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxconfigs/{id}")
  public XfR patchUpdate(@RequestBody TaxConfig taxConfig,@PathVariable Long id) {
      TaxConfig uptaxConfig = taxConfigServiceImpl.getById(id);
      if(uptaxConfig != null){
        uptaxConfig = ObjectCopyUtils.copyProperties(taxConfig,uptaxConfig,true);
      }
      return XfR.ok(taxConfigServiceImpl.updateById(uptaxConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxConfigServiceImpl.removeById(id));
  }

  @PostMapping("/taxconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_config");
     params.put("request", condition);

     return XfR.ok(taxConfigServiceImpl.querys(params));
  }

}
