package com.xforceplus.jcchengengyu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * generateModel
 * </p>
 *
 * @author ultraman
 * @since 2023-06-16
 */
public enum GenerateModel {

    _0("0", "全部合并"),
    _1("1", "按销方公司拆分"),
    _2("2", "按购方公司拆分");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    GenerateModel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static GenerateModel fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
