package com.xforceplus.jcchengengyu.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 导入发票明细
 * </p>
 *
 * @author ultraman
 * @since 2023-06-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ImportInvoice implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 销方税号
   */
  private String sellerTaxNo;

  /**
   * 商品名称
   */
  private String goodsName;

  /**
   * 商品规格
   */
  private String goodsSpec;

  /**
   * 税编简称
   */
  private String shortTaxNoName;

  /**
   * 单位
   */
  private String goodUnit;

  /**
   * 备注
   */
  private String memo;

  /**
   * 税编
   */
  private String goodsTaxNo;

  /**
   * 进项单价
   */
  private BigDecimal purchasePrice;

  /**
   * 税率
   */
  private BigDecimal taxRate;

  /**
   * 购方税号
   */
  private String purchaserTaxNo;

  /**
   * 购方名称
   */
  private String purchaserName;

  /**
   * 销方名称
   */
  private String sellerName;

  /**
   * 开票日期
   */
  private String paperDrewDate;

  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;

  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  private BigDecimal taxAmount;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 入库时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime inStockTime;

  /**
   * 原商品规格
   */
  private String goodsSpecOld;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 导入明细状态
   */
  @TableField("import_invoice_status_M6YuKyLbisVVfYadYHMtki")
  private String importInvoiceStatusM6yukylbisvvfyadyhmtki;

  /**
   * 发票类型
   */
  @TableField("invoice_type_GcKS8FHVWBq2dAEjghQzeK")
  private String invoiceTypeGcks8fhvwbq2daejghqzek;


  /**
   * 对一关联关系 关联对象 goodsInfo
   */
    private Long goodsOtmInvoiceDetailId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("goods_name", goodsName);
      map.put("goods_spec", goodsSpec);
      map.put("short_tax_no_name", shortTaxNoName);
      map.put("good_unit", goodUnit);
      map.put("memo", memo);
      map.put("goods_tax_no", goodsTaxNo);
      map.put("purchase_price", purchasePrice);
      map.put("tax_rate", taxRate);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("purchaser_name", purchaserName);
      map.put("seller_name", sellerName);
      map.put("paper_drew_date", paperDrewDate);
      map.put("amount_with_tax", amountWithTax);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("quantity", quantity);
      map.put("in_stock_time", BocpGenUtils.toTimestamp(inStockTime));
      map.put("goods_spec_old", goodsSpecOld);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("import_invoice_status_M6YuKyLbisVVfYadYHMtki", importInvoiceStatusM6yukylbisvvfyadyhmtki);
      map.put("invoice_type_GcKS8FHVWBq2dAEjghQzeK", invoiceTypeGcks8fhvwbq2daejghqzek);

       map.put("goodsOtmInvoiceDetail.id", goodsOtmInvoiceDetailId);
      return map;
  }

  public static ImportInvoice fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ImportInvoice entity = new ImportInvoice();
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_name")) {
      Object obj = map.get("goods_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_spec")) {
      Object obj = map.get("goods_spec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("short_tax_no_name")) {
      Object obj = map.get("short_tax_no_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShortTaxNoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("good_unit")) {
      Object obj = map.get("good_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("memo")) {
      Object obj = map.get("memo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMemo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_price")) {
      Object obj = map.get("purchase_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchasePrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchasePrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchasePrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchasePrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchasePrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaperDrewDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("in_stock_time")) {
      Object obj = map.get("in_stock_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInStockTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInStockTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInStockTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInStockTime(null);
      }
    }
    if(map.containsKey("goods_spec_old")) {
      Object obj = map.get("goods_spec_old");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsSpecOld((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("import_invoice_status_M6YuKyLbisVVfYadYHMtki")) {
      Object obj = map.get("import_invoice_status_M6YuKyLbisVVfYadYHMtki");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImportInvoiceStatusM6yukylbisvvfyadyhmtki((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type_GcKS8FHVWBq2dAEjghQzeK")) {
      Object obj = map.get("invoice_type_GcKS8FHVWBq2dAEjghQzeK");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceTypeGcks8fhvwbq2daejghqzek((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("goodsOtmInvoiceDetail.id")) {
        Object obj = map.get("goodsOtmInvoiceDetail.id");
      if(obj instanceof Long) {
        entity.setGoodsOtmInvoiceDetailId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setGoodsOtmInvoiceDetailId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_name")) {
      Object obj = map.get("goods_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_spec")) {
      Object obj = map.get("goods_spec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("short_tax_no_name")) {
      Object obj = map.get("short_tax_no_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShortTaxNoName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("good_unit")) {
      Object obj = map.get("good_unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("memo")) {
      Object obj = map.get("memo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMemo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_price")) {
      Object obj = map.get("purchase_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPurchasePrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPurchasePrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPurchasePrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchasePrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchasePrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaperDrewDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("in_stock_time")) {
      Object obj = map.get("in_stock_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInStockTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInStockTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInStockTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInStockTime(null);
      }
    }
    if(map.containsKey("goods_spec_old")) {
      Object obj = map.get("goods_spec_old");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsSpecOld((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("import_invoice_status_M6YuKyLbisVVfYadYHMtki")) {
      Object obj = map.get("import_invoice_status_M6YuKyLbisVVfYadYHMtki");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImportInvoiceStatusM6yukylbisvvfyadyhmtki((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_type_GcKS8FHVWBq2dAEjghQzeK")) {
      Object obj = map.get("invoice_type_GcKS8FHVWBq2dAEjghQzeK");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceTypeGcks8fhvwbq2daejghqzek((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("goodsOtmInvoiceDetail.id")) {
        Object obj = map.get("goodsOtmInvoiceDetail.id");
        if(obj instanceof Long) {
          this.setGoodsOtmInvoiceDetailId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoodsOtmInvoiceDetailId(Long.parseLong((String)obj));
        }
      }
  }
}
