package com.xforceplus.jcchengengyu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.jcchengengyu.entity.A003;
import com.xforceplus.jcchengengyu.service.IA003Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-06-16
 */
@RestController
public class A003Controller {

  @Autowired
  private IA003Service a003ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param a003 ${table.comment}
   * @return
   */
  @GetMapping("/a003s" )
  public XfR getA003s(XfPage page, A003 a003) {
    return XfR.ok(a003ServiceImpl.page(page, Wrappers.query(a003)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/a003s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(a003ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param a003 ${table.comment}
   * @return XfR
   */
  @PostMapping("/a003s")
  public XfR save(@RequestBody A003 a003) {
     return XfR.ok(a003ServiceImpl.save(a003));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param a003 ${table.comment}
   * @return XfR
   */
  @PutMapping("/a003s/{id}")
  public XfR putUpdate(@RequestBody A003 a003,@PathVariable Long id) {
      a003.setId(id);
      return XfR.ok(a003ServiceImpl.updateById(a003));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param a003 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/a003s/{id}")
  public XfR patchUpdate(@RequestBody A003 a003,@PathVariable Long id) {
      A003 upa003 = a003ServiceImpl.getById(id);
      if(upa003 != null){
        upa003 = ObjectCopyUtils.copyProperties(a003,upa003,true);
      }
      return XfR.ok(a003ServiceImpl.updateById(upa003));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/a003s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(a003ServiceImpl.removeById(id));
  }

  @PostMapping("/a003s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "a003");
     params.put("request", condition);

     return XfR.ok(a003ServiceImpl.querys(params));
  }

}
