package com.xforceplus.jccolgate.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-07-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.jccolgate.entity.SourceData;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-colgate")
public interface SourceDataFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/sourceData/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param sourceData ${table.comment}
   * @return R
   */
  @PostMapping("/sourceData/add")
  public R save(@RequestBody SourceData sourceData);

  /**
   * 修改${table.comment}
   * @param sourceData ${table.comment}
   * @return R
   */
  @PostMapping("/sourceData/update")
  public R updateById(@RequestBody SourceData sourceData);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/sourceData/del/{id}" )
  public R removeById(@PathVariable Long id);

}