package com.xforceplus.jccolgate.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单处理状态枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-07-02
 */
public enum ProcessStatusEnum {

    __2("-2", "待处理"),
    __1("-1", "导入失败"),
    _0("0", "已上传,未反馈"),
    _1("1", "导入成功"),
    _2("2", "已开票"),
    _3("3", "已删除"),
    _4("4", "已作废"),
    _5("5", "作废失败"),
    _6("6", "作废中"),
    _11("11", "开具失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProcessStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessStatusEnum fromCode(String code){
        switch(code) {
            case "-2":
                return __2;
            case "-1":
                return __1;
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "11":
                return _11;
            default:
                return null;
        }
    }
}
