package com.xforceplus.jccolgate.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 源文件状态-1-以失败 0-正常 1-已生成 2-已作废
 * </p>
 *
 * @author ultraman
 * @since 2021-07-02
 */
public enum SourceDataStatusEnum {

    _0("0", "正常"),
    _1("1", "已生成"),
    _2("2", "已作废"),
    __1("-1", "已失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SourceDataStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SourceDataStatusEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "-1":
                return __1;
            default:
                return null;
        }
    }
}
