package com.xforceplus.jccolgate.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单类型枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-07-07
 */
public enum SalesBillStatusEnum {

    _0("0", "作废"),
    _1("1", "上传"),
    _9("9", "删除"),
    __1("-1", "失败"),
    _10("10", "正常"),
    _11("11", "待计算");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SalesBillStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SalesBillStatusEnum fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "9":
                return _9;
            case "-1":
                return __1;
            case "10":
                return _10;
            case "11":
                return _11;
            default:
                return null;
        }
    }
}
